extern char *malloc(), *realloc();
# define Y_EOF 0
# define Y_NL 258
# define Y_INT 259
# define Y_ID 260
# define Y_REG 261
# define Y_FP_REG 262
# define Y_STR 263
# define Y_FP 264
# define Y_ABS_D_OP 265
# define Y_ABS_S_OP 266
# define Y_ADDIU_OP 267
# define Y_ADDI_OP 268
# define Y_ADDU_OP 269
# define Y_ADD_D_OP 270
# define Y_ADD_OP 271
# define Y_ADD_S_OP 272
# define Y_ANDI_OP 273
# define Y_AND_OP 274
# define Y_BC0F_OP 275
# define Y_BC0T_OP 276
# define Y_BC1F_OP 277
# define Y_BC1T_OP 278
# define Y_BC2F_OP 279
# define Y_BC2T_OP 280
# define Y_BC3F_OP 281
# define Y_BC3T_OP 282
# define Y_BEQ_OP 283
# define Y_BGEZAL_OP 284
# define Y_BGEZ_OP 285
# define Y_BGTZ_OP 286
# define Y_BLEZ_OP 287
# define Y_BLTZAL_OP 288
# define Y_BLTZ_OP 289
# define Y_BNE_OP 290
# define Y_BREAK_OP 291
# define Y_CFC0_OP 292
# define Y_CFC1_OP 293
# define Y_CFC2_OP 294
# define Y_CFC3_OP 295
# define Y_COP0_OP 296
# define Y_COP1_OP 297
# define Y_COP2_OP 298
# define Y_COP3_OP 299
# define Y_CTC0_OP 300
# define Y_CTC1_OP 301
# define Y_CTC2_OP 302
# define Y_CTC3_OP 303
# define Y_CVT_D_S_OP 304
# define Y_CVT_D_W_OP 305
# define Y_CVT_S_D_OP 306
# define Y_CVT_S_W_OP 307
# define Y_CVT_W_D_OP 308
# define Y_CVT_W_S_OP 309
# define Y_C_EQ_D_OP 310
# define Y_C_EQ_S_OP 311
# define Y_C_F_D_OP 312
# define Y_C_F_S_OP 313
# define Y_C_LE_D_OP 314
# define Y_C_LE_S_OP 315
# define Y_C_LT_D_OP 316
# define Y_C_LT_S_OP 317
# define Y_C_NGE_D_OP 318
# define Y_C_NGE_S_OP 319
# define Y_C_NGLE_D_OP 320
# define Y_C_NGLE_S_OP 321
# define Y_C_NGL_D_OP 322
# define Y_C_NGL_S_OP 323
# define Y_C_NGT_D_OP 324
# define Y_C_NGT_S_OP 325
# define Y_C_OLE_D_OP 326
# define Y_C_OLE_S_OP 327
# define Y_C_SEQ_D_OP 328
# define Y_C_SEQ_S_OP 329
# define Y_C_SF_D_OP 330
# define Y_C_SF_S_OP 331
# define Y_C_UEQ_D_OP 332
# define Y_C_UEQ_S_OP 333
# define Y_C_ULE_D_OP 334
# define Y_C_ULE_S_OP 335
# define Y_C_UN_D_OP 336
# define Y_C_UN_S_OP 337
# define Y_DIVU_OP 338
# define Y_DIV_D_OP 339
# define Y_DIV_OP 340
# define Y_DIV_S_OP 341
# define Y_JALR_OP 342
# define Y_JAL_OP 343
# define Y_JR_OP 344
# define Y_J_OP 345
# define Y_LBU_OP 346
# define Y_LB_OP 347
# define Y_LHU_OP 348
# define Y_LH_OP 349
# define Y_LUI_OP 350
# define Y_LWC0_OP 351
# define Y_LWC1_OP 352
# define Y_LWC2_OP 353
# define Y_LWC3_OP 354
# define Y_LWL_OP 355
# define Y_LWR_OP 356
# define Y_LW_OP 357
# define Y_MFC0_OP 358
# define Y_MFC1_OP 359
# define Y_MFC2_OP 360
# define Y_MFC3_OP 361
# define Y_MFHI_OP 362
# define Y_MFLO_OP 363
# define Y_MOV_D_OP 364
# define Y_MOV_S_OP 365
# define Y_MTC0_OP 366
# define Y_MTC1_OP 367
# define Y_MTC2_OP 368
# define Y_MTC3_OP 369
# define Y_MTHI_OP 370
# define Y_MTLO_OP 371
# define Y_MULTU_OP 372
# define Y_MULT_OP 373
# define Y_MUL_D_OP 374
# define Y_MUL_S_OP 375
# define Y_NEG_D_OP 376
# define Y_NEG_S_OP 377
# define Y_NOR_OP 378
# define Y_ORI_OP 379
# define Y_OR_OP 380
# define Y_PFW_OP 381
# define Y_RFE_OP 382
# define Y_SB_OP 383
# define Y_SH_OP 384
# define Y_SLLV_OP 385
# define Y_SLL_OP 386
# define Y_SLTIU_OP 387
# define Y_SLTI_OP 388
# define Y_SLTU_OP 389
# define Y_SLT_OP 390
# define Y_SRAV_OP 391
# define Y_SRA_OP 392
# define Y_SRLV_OP 393
# define Y_SRL_OP 394
# define Y_SUBU_OP 395
# define Y_SUB_D_OP 396
# define Y_SUB_OP 397
# define Y_SUB_S_OP 398
# define Y_SWC0_OP 399
# define Y_SWC1_OP 400
# define Y_SWC2_OP 401
# define Y_SWC3_OP 402
# define Y_SWL_OP 403
# define Y_SWR_OP 404
# define Y_SW_OP 405
# define Y_SYSCALL_OP 406
# define Y_TLBP_OP 407
# define Y_TLBR_OP 408
# define Y_TLBWI_OP 409
# define Y_TLBWR_OP 410
# define Y_XORI_OP 411
# define Y_XOR_OP 412
# define Y_ABS_POP 413
# define Y_BAL_POP 414
# define Y_BEQZ_POP 415
# define Y_BGEU_POP 416
# define Y_BGE_POP 417
# define Y_BGTU_POP 418
# define Y_BGT_POP 419
# define Y_BLEU_POP 420
# define Y_BLE_POP 421
# define Y_BLTU_POP 422
# define Y_BLT_POP 423
# define Y_BNEZ_POP 424
# define Y_B_POP 425
# define Y_LA_POP 426
# define Y_LD_POP 427
# define Y_LI_POP 428
# define Y_LI_D_POP 429
# define Y_LI_S_POP 430
# define Y_L_D_POP 431
# define Y_L_S_POP 432
# define Y_MFC1_D_POP 433
# define Y_MTC1_D_POP 434
# define Y_MOVE_POP 435
# define Y_MULOU_POP 436
# define Y_MULO_POP 437
# define Y_MUL_POP 438
# define Y_NEGU_POP 439
# define Y_NEG_POP 440
# define Y_NOP_POP 441
# define Y_NOT_POP 442
# define Y_REMU_POP 443
# define Y_REM_POP 444
# define Y_ROL_POP 445
# define Y_ROR_POP 446
# define Y_SD_POP 447
# define Y_SEQ_POP 448
# define Y_SGEU_POP 449
# define Y_SGE_POP 450
# define Y_SGTU_POP 451
# define Y_SGT_POP 452
# define Y_SLEU_POP 453
# define Y_SLE_POP 454
# define Y_SNE_POP 455
# define Y_S_D_POP 456
# define Y_S_S_POP 457
# define Y_ULHU_POP 458
# define Y_ULH_POP 459
# define Y_ULW_POP 460
# define Y_USH_POP 461
# define Y_USW_POP 462
# define Y_ALIAS_DIR 463
# define Y_ALIGN_DIR 464
# define Y_ASCII_DIR 465
# define Y_ASCIIZ_DIR 466
# define Y_ASM0_DIR 467
# define Y_BGNB_DIR 468
# define Y_BYTE_DIR 469
# define Y_COMM_DIR 470
# define Y_DATA_DIR 471
# define Y_DOUBLE_DIR 472
# define Y_ENDB_DIR 473
# define Y_ENDR_DIR 474
# define Y_END_DIR 475
# define Y_ENT_DIR 476
# define Y_ERR_DIR 477
# define Y_EXTERN_DIR 478
# define Y_FILE_DIR 479
# define Y_FLOAT_DIR 480
# define Y_FMASK_DIR 481
# define Y_FRAME_DIR 482
# define Y_GLOBAL_DIR 483
# define Y_HALF_DIR 484
# define Y_K_TEXT_DIR 485
# define Y_K_DATA_DIR 486
# define Y_LABEL_DIR 487
# define Y_LCOMM_DIR 488
# define Y_LIVEREG_DIR 489
# define Y_LOC_DIR 490
# define Y_MASK_DIR 491
# define Y_NOALIAS_DIR 492
# define Y_OPTIONS_DIR 493
# define Y_RDATA_DIR 494
# define Y_REPEAT_DIR 495
# define Y_SDATA_DIR 496
# define Y_SET_DIR 497
# define Y_SPACE_DIR 498
# define Y_STRUCT_DIR 499
# define Y_TEXT_DIR 500
# define Y_VERSTAMP_DIR 501
# define Y_VREG_DIR 502
# define Y_WORD_DIR 503

# line 289 "parser.y"
#include <stdio.h>

#include "spim.h"
#include "spim-utils.h"
#include "inst.h"
#include "mem.h"
#include "reg.h"
#include "sym-tbl.h"
#include "data.h"
#include "scanner.h"
#include "parser.h"


typedef struct ll
{
  label *head;
  struct ll *tail;
} label_list;


/* Exported Variables: */

int data_dir;			/* Non-zero means item in data segment */

int text_dir;			/* Non-zero means item in text segment */


/* Local functions: */

#ifdef __STDC__
static imm_expr *branch_offset (int n_inst);
static void clear_labels (void);
static label_list *cons_label (label *head, label_list *tail);
static void div_inst (int op, int rd, int rs, int rt, int const_divisor);
static void mult_inst (int op, int rd, int rs, int rt);
static void nop_inst (void);
static void set_eq_inst (int op, int rd, int rs, int rt);
static void set_ge_inst (int op, int rd, int rs, int rt);
static void set_gt_inst (int op, int rd, int rs, int rt);
static void set_le_inst (int op, int rd, int rs, int rt);
static void store_word_data (int value);
static void trap_inst (void);
#else
static imm_expr *branch_offset ();
static void clear_labels ();
static label_list *cons_label ();
static void div_inst ();
static void mult_inst ();
static void nop_inst ();
static void set_eq_inst ();
static void set_ge_inst ();
static void set_gt_inst ();
static void set_le_inst ();
static void store_word_data ();
static void trap_inst ();
#endif


/* Local variables: */

static int null_term;		/* Non-zero means string terminate by \0 */

static void (*store_op) ();	/* Function to store items in an EXPR_LST */

static label_list *this_line_labels = NULL; /* List of label for curent line */

static int noat_flag = 0;	/* Non-zero means program can use $1 */

static char *input_file_name;	/* Name of file being parsed */


#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 1958 "parser.y"


/* Maintain and update the address of labels for the current line. */

#ifdef __STDC__
void
fix_current_label_address (mem_addr new_addr)
#else
void
fix_current_label_address (new_addr)
     mem_addr new_addr;
#endif
{
  label_list *l;

  for (l = this_line_labels; l != NULL; l = l->tail)
    l->head->addr = new_addr;
  clear_labels ();
}


#ifdef __STDC__
static label_list *
cons_label (label *head, label_list *tail)
#else
static label_list *
cons_label (head, tail)
     label *head;
     label_list *tail;
#endif
{
  label_list *c = (label_list *) malloc (sizeof (label_list));

  c->head = head;
  c->tail = tail;
  return (c);
}


#ifdef __STDC__
static void
clear_labels (void)
#else
static void
clear_labels ()
#endif
{
  label_list *n;

  for ( ; this_line_labels != NULL; this_line_labels = n)
    {
      n = this_line_labels->tail;
      free (this_line_labels);
    }
}


/* Operations on op codes. */

#ifdef __STDC__
int
op_to_imm_op (int opcode)
#else
int
op_to_imm_op (opcode)
     int opcode;
#endif
{
  switch (opcode)
    {
    case Y_ADD_OP: return (Y_ADDI_OP);
    case Y_ADDU_OP: return (Y_ADDIU_OP);
    case Y_AND_OP: return (Y_ANDI_OP);
    case Y_OR_OP: return (Y_ORI_OP);
    case Y_XOR_OP: return (Y_XORI_OP);
    case Y_SLT_OP: return (Y_SLTI_OP);
    case Y_SLTU_OP: return (Y_SLTIU_OP);
    case Y_SLLV_OP: return (Y_SLL_OP);
    case Y_SRAV_OP: return (Y_SRA_OP);
    case Y_SRLV_OP: return (Y_SRL_OP);
    default: fatal_error ("Can't convert op to immediate op\n"); return (0);
    }
}


#ifdef __STDC__
int
imm_op_to_op (int opcode)
#else
int
imm_op_to_op (opcode)
     int opcode;
#endif
{
  switch (opcode)
    {
    case Y_ADDI_OP: return (Y_ADD_OP);
    case Y_ADDIU_OP: return (Y_ADDU_OP);
    case Y_ANDI_OP: return (Y_AND_OP);
    case Y_ORI_OP: return (Y_OR_OP);
    case Y_XORI_OP: return (Y_XOR_OP);
    case Y_SLTI_OP: return (Y_SLT_OP);
    case Y_SLTIU_OP: return (Y_SLTU_OP);
    case Y_J_OP: return (Y_JR_OP);
    case Y_LUI_OP: return (Y_ADDU_OP);
    case Y_SLL_OP: return (Y_SLLV_OP);
    case Y_SRA_OP: return (Y_SRAV_OP);
    case Y_SRL_OP: return (Y_SRLV_OP);
    default: fatal_error ("Can't convert immediate op to op\n"); return (0);
    }
}


#ifdef __STDC__
static void
nop_inst (void)
#else
static void
nop_inst ()
#endif
{
  r_type_inst (Y_OR_OP, 0, 0, 0);
}


#ifdef __STDC__
static void
trap_inst (void)
#else
static void
trap_inst ()
#endif
{
  r_type_inst (Y_BREAK_OP, 0, 0, 0);
}


#ifdef __STDC__
static imm_expr *
branch_offset (int n_inst)
#else
static imm_expr *
branch_offset (n_inst)
     int n_inst;
#endif
{
  return (const_imm_expr (n_inst << 2)); /* Later shifted right 2 places */
}


#ifdef __STDC__
static void
div_inst (int op, int rd, int rs, int rt, int const_divisor)
#else
static void
div_inst (op, rd, rs, rt, const_divisor)
     int op, rd, rs, rt, const_divisor;
#endif
{
  if (rd != 0 && !const_divisor)
    {
      i_type_inst (Y_BNE_OP, 0, rt, branch_offset (2));
      trap_inst ();
    }
  if (op == Y_DIV_OP || op == Y_REM_POP)
    r_type_inst (Y_DIV_OP, 0, rs, rt);
  else
    r_type_inst (Y_DIVU_OP, 0, rs, rt);
  if (rd != 0)
    {
      if (op == Y_DIV_OP || op == Y_DIVU_OP)
	r_type_inst (Y_MFLO_OP, rd, 0, 0);
      else
	r_type_inst (Y_MFHI_OP, rd, 0, 0);
    }
}


#ifdef __STDC__
static void
mult_inst (int op, int rd, int rs, int rt)
#else
static void
mult_inst (op, rd, rs, rt)
     int op, rd, rs, rt;
#endif
{
  if (op == Y_MULOU_POP)
    r_type_inst (Y_MULTU_OP, 0, rs, rt);
  else
    r_type_inst (Y_MULT_OP, 0, rs, rt);
  if (op == Y_MULOU_POP && rd != 0)
    {
      r_type_inst (Y_MFHI_OP, 1, 0, 0);	/* Use $at */
      i_type_inst (Y_BEQ_OP, 0, 1, branch_offset (2));
      trap_inst ();
    }
  else if (op == Y_MULO_POP && rd != 0)
    {
      r_type_inst (Y_MFHI_OP, 1, 0, 0); /* use $at */
      r_type_inst (Y_MFLO_OP, rd, 0, 0);
      r_sh_type_inst (Y_SRA_OP, rd, rd, 31);
      i_type_inst (Y_BEQ_OP, rd, 1, branch_offset (2));
      trap_inst ();
    }
  if (rd != 0)
    r_type_inst (Y_MFLO_OP, rd, 0, 0);
}


#ifdef __STDC__
static void
set_le_inst (int op, int rd, int rs, int rt)
#else
static void
set_le_inst (op, rd, rs, rt)
     int op, rd, rs, rt;
#endif
{
  i_type_inst (Y_BNE_OP, rs, rt, branch_offset (3));
  i_type_inst (Y_ORI_OP, rd, 0, const_imm_expr (1));
  i_type_inst (Y_BEQ_OP, 0, 0, branch_offset (2));
  r_type_inst ((op == Y_SLE_POP ? Y_SLT_OP : Y_SLTU_OP), rd, rs, rt);
}


#ifdef __STDC__
static void
set_gt_inst (int op, int rd, int rs, int rt)
#else
static void
set_gt_inst (op, rd, rs, rt)
     int op, rd, rs, rt;
#endif
{
  r_type_inst (op == Y_SGT_POP ? Y_SLT_OP : Y_SLTU_OP, rd, rt, rs);
}


#ifdef __STDC__
static void
set_ge_inst (int op, int rd, int rs, int rt)
#else
static void
set_ge_inst (op, rd, rs, rt)
     int op, rd, rs, rt;
#endif
{
  i_type_inst (Y_BNE_OP, rs, rt, branch_offset (3));
  i_type_inst (Y_ORI_OP, rd, 0, const_imm_expr (1));
  i_type_inst (Y_BEQ_OP, 0, 0, branch_offset (2));
  r_type_inst (op == Y_SGE_POP ? Y_SLT_OP : Y_SLTU_OP, rd, rt, rs);
}


#ifdef __STDC__
static void
set_eq_inst (int op, int rd, int rs, int rt)
#else
static void
set_eq_inst (op, rd, rs, rt)
     int op, rd, rs, rt;
#endif
{
  imm_expr *if_eq, *if_neq;

  if (op == Y_SEQ_POP)
    if_eq = const_imm_expr (1), if_neq = const_imm_expr (0);
  else
    if_eq = const_imm_expr (0), if_neq = const_imm_expr (1);

  i_type_inst (Y_BEQ_OP, rs, rt, branch_offset (3));
  /* RD <- 0 (if not equal) */
  i_type_inst (Y_ORI_OP, rd, 0, if_neq);
  i_type_inst (Y_BEQ_OP, 0, 0, branch_offset (2)); /* Branch always */
  /* RD <- 1 */
  i_type_inst (Y_ORI_OP, rd, 0, if_eq);
}


/* Store the value either as a datum or instruction. */

#ifdef __STDC__
static void
store_word_data (int value)
#else
static void
store_word_data (value)
     int value;
#endif
{
  if (data_dir)
    store_word (value);
  else if (text_dir)
    store_instruction (inst_decode (value));
}



#ifdef __STDC__
void
initialize_parser (char *file_name)
#else
void
initialize_parser (file_name)
     char *file_name;
#endif
{
  input_file_name = file_name;
  only_id = 0;
  data_dir = 0;
  text_dir = 1;
}


#ifdef __STDC__
void
yyerror (char *s)
#else
void
yyerror (s)
     char *s;
#endif
{
  error ("spim: (parser) %s on line %d of file %s\n",
	 s, line_no, input_file_name);
  print_erroneous_line ();
}
int yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 2,
	260, 376,
	-2, 5,
-1, 346,
	261, 348,
	-2, 346,
-1, 372,
	260, 376,
	-2, 375,
-1, 476,
	258, 277,
	-2, 363,
-1, 490,
	258, 299,
	-2, 363,
-1, 498,
	258, 322,
	-2, 363,
	};
# define YYNPROD 378
# define YYLAST 1083
int yyact[]={

    10,   552,   406,   481,   413,   412,   474,   486,   293,   294,
   300,   406,   513,   511,   291,   291,   500,   430,   291,   291,
   495,   471,   387,   359,   506,   286,   581,   409,   566,   480,
   565,   477,   564,   554,   473,   361,   497,   496,   494,   493,
   492,   489,   488,   472,   484,   400,   397,   396,   395,   391,
   390,   386,   385,   384,   310,   378,   376,   373,   369,   368,
   365,   312,   288,   287,   298,   349,   578,   573,   284,   550,
   548,   285,   558,   289,   504,   559,   505,   560,   556,     5,
   583,   557,   301,   582,   575,   304,   574,   295,   296,   297,
   567,   561,   302,   303,   577,   576,   482,   372,   478,   452,
   305,   499,   405,   313,   314,   315,   316,   317,   318,   319,
   320,   321,   322,   323,   324,   325,   402,   328,   329,   330,
   331,   332,   333,   358,   308,   309,   399,   351,   352,   354,
   355,   356,   357,   381,   377,   371,   370,   366,   364,   363,
    68,    67,    66,    65,    64,    63,    62,    61,    60,   360,
    59,    58,   345,    57,    56,    55,    54,    53,    52,    51,
    50,    49,    48,    47,    46,    45,    42,    41,    40,    39,
    38,    37,   476,    36,    35,   334,    34,    26,    25,    22,
    21,    20,    19,    13,    12,    11,     8,     7,     6,     3,
     2,     1,     0,     0,     0,     0,     0,     0,   467,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   409,   408,   291,     0,     0,     0,     0,     0,     0,
   409,   408,     0,   343,   347,   409,   502,     0,     0,     0,
   507,     0,     0,   451,     0,     0,     0,     0,     0,   389,
     0,     0,     0,   393,   394,     0,     0,   404,     9,     0,
     0,     0,     0,     0,     0,   239,   238,   153,   152,   143,
   241,   142,   240,   154,   144,   186,   182,   187,   183,   188,
   184,   189,   185,   198,   191,   190,   192,   193,   195,   194,
   199,    27,   230,   231,   232,   233,     0,     0,   440,     0,
   234,   235,   236,   237,   248,   249,   250,   251,   252,   253,
   272,   258,   270,   256,   282,   268,   280,   266,   281,   267,
   277,   263,   279,   265,   283,   269,   274,   260,   278,   264,
   276,   262,   273,   259,   275,   261,   271,   257,   166,   243,
   165,   242,   211,   210,   209,   208,   111,   110,   113,   112,
   122,   119,   125,   120,   121,   115,   116,   114,   220,   221,
   223,   224,   216,   217,   215,   214,   225,   226,   228,   229,
   218,   219,   173,   172,   245,   244,   255,   254,   162,   155,
   146,   118,   140,   128,   129,   149,   159,   158,   157,   148,
   147,   150,   160,   151,   161,   164,   247,   163,   246,   134,
   137,   135,   136,   131,   132,   130,   141,   487,   475,   465,
   466,   156,   145,    29,   213,   196,   203,   202,   201,   200,
   207,   206,   205,   204,   197,   212,    14,   117,    15,    16,
    17,   127,   126,   222,   227,    33,   171,   170,   169,    31,
    30,    28,    32,   168,   167,    44,    43,   133,   180,   179,
   178,   177,   176,   175,   174,   181,   139,   138,   124,   123,
    18,    24,    23,    69,    70,    71,    72,    73,    74,    75,
    76,    77,    79,    81,    82,    80,    83,    85,    84,    86,
    87,    88,    89,    90,    91,   106,    78,    92,    93,    94,
    95,    96,    97,    98,   100,    99,   101,   102,   103,   104,
   105,   107,   108,   109,   327,   501,   299,   547,   549,   503,
   547,   407,   448,   449,     4,   401,   290,   479,   290,   290,
   290,     0,   549,   290,   290,   485,   306,     0,   306,   306,
   549,     0,   311,   491,   290,   290,   290,   290,   290,   290,
   290,   290,   290,   290,   290,   290,   290,     0,   290,   290,
   290,   290,   290,   290,   490,   411,   469,   470,     0,     0,
     0,   335,   346,     0,     0,   350,   350,   350,     0,   335,
   335,     0,   498,     0,     0,   311,   428,     0,   432,     0,
   435,   437,   362,   454,   456,   458,   460,     0,   367,     0,
     0,   326,     0,     0,   379,   374,   375,     0,     0,     0,
     0,     0,   380,     0,   382,   383,     0,   562,   563,     0,
   388,   362,     0,   398,   392,   362,   362,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   535,   536,   551,   538,
   539,   540,   541,   542,   543,   544,   545,   450,   453,   455,
   457,   459,   336,   337,   338,   339,   340,   341,   342,   344,
     0,     0,     0,   292,     0,     0,     0,     0,     0,     0,
     0,     0,   571,   572,     0,   546,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   307,     0,     0,     0,
     0,     0,     0,     0,     0,   509,     0,     0,     0,   512,
     0,     0,   516,     0,   518,     0,   520,   522,     0,     0,
   524,   526,   528,   530,   532,   534,     0,     0,     0,     0,
   537,     0,     0,   348,     0,     0,     0,   353,     0,     0,
     0,     0,     0,     0,     0,     0,   508,     0,   510,     0,
     0,     0,   514,   515,     0,   517,     0,   519,   521,     0,
     0,   523,   525,   527,   529,   531,   533,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   403,     0,
     0,     0,   410,     0,     0,     0,     0,     0,   414,   415,
   416,   417,     0,   418,   419,   420,   421,     0,     0,     0,
     0,   441,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   441,   441,   441,   441,   441,   335,   335,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   311,   311,   468,   468,   468,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   362,
     0,     0,     0,     0,   483,     0,     0,   362,     0,     0,
     0,     0,     0,     0,     0,   362,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   422,   423,   424,   425,   426,
   427,   429,   431,   433,   434,   436,   438,   439,     0,     0,
   442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
     0,     0,   441,     0,   441,     0,     0,   461,   441,   441,
     0,   441,     0,   441,   441,     0,     0,   441,   441,   441,
   441,   441,   441,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   335,   335,     0,   335,   335,   335,   335,   335,
   335,   335,   335,   468,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   362,     0,     0,     0,   553,     0,     0,     0,     0,     0,
     0,     0,   462,     0,     0,   555,   463,   464,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   568,     0,   570,     0,     0,     0,     0,     0,   569,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   579,   580 };
int yypact[]={

 -1000, -1000, -1000,     0,    10,  -235, -1000,  -195,  -196, -1000,
 -1000,  -243,  -253,  -243,  -243,  -243,  -252,  -252,  -243,  -243,
  -252,  -243,  -253,  -243,  -243,  -252, -1000,  -198, -1000,  -243,
  -243,  -243,  -243,  -243,  -243,  -243,  -243,  -243,  -243,  -243,
  -243,  -243,  -243,  -243,  -243,  -243,  -243,  -243,  -243, -1000,
  -243,  -243,  -243,  -243,  -243,  -243,  -243,  -243, -1000,  -253,
  -243,  -243,  -243,  -253,  -252,  -252,  -252,  -252,  -252,  -238,
  -224, -1000, -1000, -1000,  -199, -1000, -1000,  -200,  -201, -1000,
 -1000,  -202, -1000, -1000, -1000, -1000,  -203, -1000,  -204,  -243,
 -1000, -1000, -1000, -1000,  -206,  -207,  -208,  -239, -1000,  -224,
  -209,  -210, -1000,  -224,  -224,  -211,  -212,  -213,  -243, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000,  -214, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000,   -29, -1000,   -29,  -259, -1000,
 -1000,  -260, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000,  -243,  -243,  -243,  -243,  -243,   -38,  -242,
   -38,  -243,   -38,   -38,  -243,  -243,  -243, -1000,  -243,  -243,
  -243,  -243,  -243,  -243, -1000, -1000, -1000, -1000,  -243,  -243,
  -243,  -243,  -243, -1000, -1000,  -243, -1000, -1000,  -253, -1000,
 -1000, -1000,  -253,  -253,  -252,  -252,  -252,  -252,  -252,  -240,
 -1000, -1000, -1000,  -257,  -257, -1000, -1000,  -224, -1000, -1000,
  -261, -1000, -1000, -1000,  -215,  -224,  -256,  -261,  -217,  -218,
 -1000, -1000, -1000,  -224,  -219,  -220,  -221,  -241, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000,  -222,  -223, -1000,
 -1000, -1000,   -24, -1000, -1000, -1000,  -232, -1000,    31,   -19,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000,   -38, -1000,  -246,
 -1000,   -29, -1000,  -247,   -38, -1000,   -38, -1000,   -38,   -38,
 -1000, -1000,   -38,   -38,   -38,   -38,   -38,   -38, -1000, -1000,
 -1000, -1000,   -29, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000,  -252, -1000, -1000, -1000,
 -1000, -1000,  -257, -1000,    12,  -257, -1000,    11,  -224, -1000,
  -263, -1000, -1000, -1000, -1000, -1000, -1000,  -263, -1000,  -243,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000,  -226, -1000, -1000,
  -243,    38,    32,    50,  -232,  -232,  -227, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,  -229, -1000,
  -231, -1000, -1000, -1000, -1000,    49,  -243, -1000,  -243,  -232,
  -232,     5, -1000, -1000, -1000, -1000, -1000, -1000,    45, -1000,
    43,    55,    54,     4, -1000, -1000,  -243,  -243,  -233,    42,
    39, -1000, -1000, -1000 };
int yypgo[]={

     0,   191,   190,   189,   188,   511,   187,   186,   185,    73,
   515,   184,   653,   183,   257,    64,   182,   181,   180,   100,
   179,   178,    54,   177,   591,   176,   298,   174,   173,   171,
   170,   169,   168,   167,   166,   165,   164,   163,   162,   161,
   175,   160,   159,   158,   243,   157,   156,   155,   154,   153,
   152,   151,   150,   148,    65,   147,   146,   145,   144,   143,
   198,   142,   141,   140,   149,   139,    43,   138,   137,   172,
   136,    29,   135,   134,   504,   133,   126,   116,   101,   102,
    99,   506,    34,    31,    98,    97,    96,    79 };
int yyr1[]={

     0,     2,     1,     3,     3,     3,     4,     4,     4,     4,
     6,     6,     6,     6,     6,     6,     6,     6,     6,     6,
     6,     6,     6,     6,     6,     6,     6,     6,     6,     6,
     6,     6,     6,     6,     6,     6,     6,     6,     6,     6,
     6,     6,     6,     6,     6,     6,     6,     6,     6,     6,
     6,     6,     6,     6,     6,     6,     6,     6,     6,     6,
     6,     6,     6,     6,     6,     6,     6,     6,     6,     6,
     6,     6,     6,     6,     6,     6,     6,     6,     6,     6,
     6,     6,     6,     6,     6,     6,     6,     6,     6,     6,
     6,     6,     6,     6,     8,     8,     8,     8,     8,     8,
     8,     8,     8,    11,    11,    11,    13,    16,    16,    17,
    17,    17,    18,    18,    18,    18,    18,    18,    20,    20,
    20,    21,    21,    21,    23,    23,    25,    25,    25,    25,
    25,    25,    25,    27,    27,    27,    28,    28,    28,    28,
    28,    28,    28,    29,    29,    29,    30,    31,    31,    32,
    32,    32,    32,    33,    33,    33,    35,    35,    36,    36,
    37,    37,    38,    38,    34,    34,    39,    39,    39,    39,
    39,    39,    39,    39,    41,    41,    41,    41,    41,    41,
    42,    42,    43,    43,    45,    45,    46,    46,    47,    47,
    48,    48,    49,    49,    49,    49,    51,    51,    52,    52,
    53,    53,    55,    55,    56,    56,    56,    56,    56,    56,
    56,    56,    56,    56,    57,    57,    57,    57,    57,    57,
    57,    57,    58,    58,    59,    59,    59,    59,    59,    59,
    59,    59,    61,    61,    61,    61,    61,    61,    62,    62,
    63,    63,    63,    63,    63,    63,    63,    63,    63,    63,
    63,    63,    63,    63,    63,    63,    63,    63,    63,    63,
    63,    63,    63,    63,    63,    63,    63,    63,     7,     7,
    65,     7,    67,     7,     7,     7,    68,     7,     7,     7,
     7,     7,     7,    70,     7,     7,     7,     7,     7,     7,
     7,     7,     7,    73,     7,     7,     7,     7,    75,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,    76,     7,    77,    10,    78,    78,    78,    78,    78,
    78,    78,    78,    78,    78,    80,    44,    14,    14,    14,
    14,    14,    79,    79,    79,     9,    24,    26,    50,    54,
    19,    74,    15,    22,    60,    81,    12,    12,    40,    66,
    66,    82,    82,    84,    83,    64,    64,    69,    69,    69,
    71,    71,    85,    72,    86,    86,    87,     5 };
int yyr2[]={

     0,     1,     6,     5,     7,     1,     5,     5,     3,     3,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     3,     5,     3,     7,     7,
     7,     7,     7,     9,     9,     7,     9,     9,     7,     9,
     7,     9,     9,     9,     9,     7,     9,     9,     7,     7,
     9,     9,     9,     9,     7,     9,     9,     9,     9,     9,
     9,     9,     9,     9,     9,     9,     9,     5,     7,     7,
     9,     9,     9,     9,     9,     9,     9,     9,     9,     9,
     5,     5,     7,     5,     7,     5,     5,     7,     7,     7,
     9,     7,     7,     7,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     6,     5,
     1,     7,     1,     7,     2,     4,     1,     7,     7,     3,
     5,     3,     5,     1,     7,     4,     4,     2,     4,     6,
     7,     3,     6,     1,     7,     6,     8,     5,     1,     7,
     5,     7,     6,     6,     6,     6,     4,     5,     3,     5,
     3,     5,     5,     5,     5,     3,     5,     3,     5,     6,
     8,     1,     6,     1,     5,     7,     3,     9,     3,     9,
     7,     7,     7,    13,    13,     1,     5,     3,    13,     3,
     7,     7,     2,     7,     5,     2,     2,     2,     2,     2,
     2,     3,     2,     2,     2,     3,     2,     2,     3,     4,
     2,     3,     7,     1,     5,     2,     3,     5,     3,     7,
     5,     3,     1,     5,     2,     1,     1,     5 };
int yychk[]={

 -1000,    -1,    -2,    -3,    -5,   -87,    -4,    -6,    -7,   258,
     0,    -8,   -11,   -13,   426,   428,   429,   430,   460,   -16,
   -17,   -18,   -20,   462,   461,   -21,   -23,   291,   441,   413,
   440,   439,   442,   435,   -25,   -27,   -28,   -29,   -30,   -31,
   -32,   -33,   -34,   446,   445,   -35,   -36,   -37,   -38,   -39,
   -41,   -42,   -43,   -45,   -46,   -47,   -48,   -49,   -51,   -52,
   -53,   -55,   -56,   -57,   -58,   -59,   -61,   -62,   -63,   463,
   464,   465,   466,   467,   468,   469,   470,   471,   486,   472,
   475,   473,   474,   476,   478,   477,   479,   480,   481,   482,
   483,   484,   487,   488,   489,   490,   491,   492,   493,   495,
   494,   496,   497,   498,   499,   500,   485,   501,   502,   503,
   347,   346,   349,   348,   357,   355,   356,   427,   381,   351,
   353,   354,   350,   459,   458,   352,   432,   431,   383,   384,
   405,   403,   404,   447,   399,   401,   402,   400,   457,   456,
   382,   406,   271,   269,   274,   412,   380,   390,   389,   385,
   391,   393,   268,   267,   273,   379,   411,   388,   387,   386,
   392,   394,   378,   397,   395,   340,   338,   444,   443,   438,
   437,   436,   373,   372,   454,   453,   452,   451,   450,   449,
   448,   455,   276,   278,   280,   282,   275,   277,   279,   281,
   285,   284,   286,   287,   289,   288,   415,   424,   283,   290,
   419,   418,   417,   416,   423,   422,   421,   420,   345,   344,
   343,   342,   425,   414,   365,   364,   362,   363,   370,   371,
   358,   359,   433,   360,   361,   366,   367,   434,   368,   369,
   292,   293,   294,   295,   300,   301,   302,   303,   266,   265,
   272,   270,   341,   339,   375,   374,   398,   396,   304,   305,
   306,   307,   308,   309,   377,   376,   313,   337,   311,   333,
   327,   335,   331,   321,   329,   323,   317,   319,   315,   325,
   312,   336,   310,   332,   326,   334,   330,   320,   328,   322,
   316,   318,   314,   324,    58,    61,   260,   258,   258,    -9,
   -74,   261,   -12,   261,   262,    -9,    -9,    -9,   -15,   -81,
   262,   -15,    -9,    -9,   -15,   -19,   -74,   -12,   -19,   -19,
   -22,   -81,   259,    -9,    -9,    -9,    -9,    -9,    -9,    -9,
    -9,    -9,    -9,    -9,    -9,    -9,   -24,   -74,    -9,    -9,
    -9,    -9,    -9,    -9,   -40,    -5,   -24,   -24,   -24,   -24,
   -24,   -24,   -24,   -40,   -24,   -50,   -74,   -40,   -12,   -54,
   -74,   -54,   -54,   -12,   -15,   -15,   -15,   -15,   -22,   261,
   -64,   259,    -5,   -65,   -67,   259,   -68,    -5,   259,   259,
   -70,   -72,   -85,   259,    -5,    -5,   259,   -73,   259,   -74,
    -5,   -75,    -5,    -5,   259,   259,   259,   261,    -5,   -64,
   259,   259,    -5,   -64,   -64,   259,   259,   259,   -74,   -76,
   259,   -10,   -77,   -10,   -14,   -79,    40,    -5,   260,   259,
   -10,   -14,   264,   264,   -10,   -10,   -10,   -10,   -10,   -10,
   -10,   -10,   -24,   -24,   -24,   -24,   -24,   -24,   -14,   -24,
   259,   -24,   -14,   -24,   -24,   -14,   -24,   -14,   -24,   -24,
   -26,   -74,   -24,   -24,   -24,   -24,   -24,   -24,   -40,   -40,
   -26,   -44,   -80,   -26,   -44,   -26,   -44,   -26,   -44,   -26,
   -44,   -24,   -12,   -12,   -12,   -22,   -22,   -60,   -81,   -60,
   -60,   261,   -66,   -82,   263,   -66,   -69,   -83,   -84,   -64,
   -71,   264,   -86,    -5,   259,   -64,   263,   -71,   259,   259,
   -69,   -64,   259,   259,   259,   261,   259,   259,   -69,   -78,
    40,   -79,   260,   -79,    43,    45,    43,   259,   -26,   -14,
   -26,   259,   -14,   259,   -26,   -26,   -14,   -26,   -14,   -26,
   -14,   -26,   -14,   -26,   -14,   -26,   -14,   -26,   -14,   -26,
   -14,   -26,   -14,   -26,   -14,   -40,   -40,   -14,   -40,   -40,
   -40,   -40,   -40,   -40,   -40,   -40,   -60,   -82,    58,   -83,
    58,   -64,   264,   -74,   259,   -74,    40,    43,    40,    43,
    45,    41,   -79,   -79,   259,   259,   259,    41,   -74,    -5,
   -74,   -79,   -79,    62,    41,    41,    40,    40,    62,   -74,
   -74,   259,    41,    41 };
int yydef[]={

     1,    -2,    -2,     0,     0,     0,     2,     0,     0,     8,
     9,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    25,     0,    27,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   376,
     0,     0,     0,     0,     0,     0,     0,   376,   376,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   376,   270,   272,   274,     0,   276,   376,   279,   281,   283,
   372,     0,   287,   376,   376,   291,     0,   293,     0,     0,
   376,   298,   376,   376,     0,     0,     0,     0,   376,   376,
   308,   310,   376,   376,   376,   315,   317,     0,     0,   321,
    94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
   104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
   114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
   124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
   134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
   144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
   154,   155,   164,   165,   156,   157,   158,   159,   160,   161,
   162,   163,   166,   167,   168,   169,   170,   171,   172,   173,
   174,   175,   176,   177,   178,   179,   180,   181,   182,   183,
   184,   185,   186,   187,   188,   189,   190,   191,   192,   193,
   194,   195,   196,   197,   198,   199,   200,   201,   202,   203,
   204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
   214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
   224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
   234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
   244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
   254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
   264,   265,   266,   267,     3,     0,   377,     6,     7,   323,
   345,   351,   323,   356,   357,     0,   323,     0,     0,   352,
   355,     0,   323,   323,   323,   323,   350,   323,   323,   323,
   323,   353,    26,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   346,     0,     0,
     0,     0,     0,     0,    67,   358,   376,   376,   335,   335,
   335,   335,   335,    80,    81,     0,    -2,    83,     0,    85,
   349,    86,     0,     0,     0,     0,     0,     0,     0,     0,
   269,   365,   366,     0,     0,   275,   363,   376,   280,   282,
     0,   285,    -2,   286,   288,   376,     0,     0,     0,     0,
   297,   363,   300,   376,     0,     0,     0,     0,   306,   307,
   309,   311,   312,   313,   314,   316,   318,     0,     0,   363,
     4,    10,     0,    11,    12,   337,     0,   339,     0,   342,
    13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
    23,    24,    28,    29,    30,    31,    32,     0,    35,     0,
    38,     0,    40,     0,     0,    45,     0,    48,    49,     0,
    54,   347,     0,     0,     0,     0,     0,     0,    68,    69,
   376,   376,     0,   376,   376,   376,   376,   376,   376,   376,
   376,    82,    84,    87,    88,    89,     0,    91,   354,    92,
    93,   268,   271,   360,   361,   273,    -2,   368,   376,   278,
   284,   371,   373,   374,   289,   290,   292,   294,   295,     0,
    -2,   301,   302,   303,   304,   305,   319,     0,    -2,   324,
     0,   326,   328,     0,     0,     0,     0,   344,    33,    34,
    36,    37,    39,    41,    42,    43,    44,    46,    47,    50,
    51,    52,    53,    55,    57,    56,    58,    59,    60,    61,
    62,    63,    64,    65,    66,    70,    71,   336,    72,    73,
    74,    75,    76,    77,    78,    79,    90,   359,     0,   367,
     0,   364,   370,   296,   320,     0,     0,   376,     0,     0,
     0,     0,   340,   341,   343,   362,   369,   325,     0,   331,
     0,   330,   332,     0,   327,   329,     0,     0,     0,     0,
     0,   338,   333,   334 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"Y_EOF",	0,
	"Y_NL",	258,
	"Y_INT",	259,
	"Y_ID",	260,
	"Y_REG",	261,
	"Y_FP_REG",	262,
	"Y_STR",	263,
	"Y_FP",	264,
	"Y_ABS_D_OP",	265,
	"Y_ABS_S_OP",	266,
	"Y_ADDIU_OP",	267,
	"Y_ADDI_OP",	268,
	"Y_ADDU_OP",	269,
	"Y_ADD_D_OP",	270,
	"Y_ADD_OP",	271,
	"Y_ADD_S_OP",	272,
	"Y_ANDI_OP",	273,
	"Y_AND_OP",	274,
	"Y_BC0F_OP",	275,
	"Y_BC0T_OP",	276,
	"Y_BC1F_OP",	277,
	"Y_BC1T_OP",	278,
	"Y_BC2F_OP",	279,
	"Y_BC2T_OP",	280,
	"Y_BC3F_OP",	281,
	"Y_BC3T_OP",	282,
	"Y_BEQ_OP",	283,
	"Y_BGEZAL_OP",	284,
	"Y_BGEZ_OP",	285,
	"Y_BGTZ_OP",	286,
	"Y_BLEZ_OP",	287,
	"Y_BLTZAL_OP",	288,
	"Y_BLTZ_OP",	289,
	"Y_BNE_OP",	290,
	"Y_BREAK_OP",	291,
	"Y_CFC0_OP",	292,
	"Y_CFC1_OP",	293,
	"Y_CFC2_OP",	294,
	"Y_CFC3_OP",	295,
	"Y_COP0_OP",	296,
	"Y_COP1_OP",	297,
	"Y_COP2_OP",	298,
	"Y_COP3_OP",	299,
	"Y_CTC0_OP",	300,
	"Y_CTC1_OP",	301,
	"Y_CTC2_OP",	302,
	"Y_CTC3_OP",	303,
	"Y_CVT_D_S_OP",	304,
	"Y_CVT_D_W_OP",	305,
	"Y_CVT_S_D_OP",	306,
	"Y_CVT_S_W_OP",	307,
	"Y_CVT_W_D_OP",	308,
	"Y_CVT_W_S_OP",	309,
	"Y_C_EQ_D_OP",	310,
	"Y_C_EQ_S_OP",	311,
	"Y_C_F_D_OP",	312,
	"Y_C_F_S_OP",	313,
	"Y_C_LE_D_OP",	314,
	"Y_C_LE_S_OP",	315,
	"Y_C_LT_D_OP",	316,
	"Y_C_LT_S_OP",	317,
	"Y_C_NGE_D_OP",	318,
	"Y_C_NGE_S_OP",	319,
	"Y_C_NGLE_D_OP",	320,
	"Y_C_NGLE_S_OP",	321,
	"Y_C_NGL_D_OP",	322,
	"Y_C_NGL_S_OP",	323,
	"Y_C_NGT_D_OP",	324,
	"Y_C_NGT_S_OP",	325,
	"Y_C_OLE_D_OP",	326,
	"Y_C_OLE_S_OP",	327,
	"Y_C_SEQ_D_OP",	328,
	"Y_C_SEQ_S_OP",	329,
	"Y_C_SF_D_OP",	330,
	"Y_C_SF_S_OP",	331,
	"Y_C_UEQ_D_OP",	332,
	"Y_C_UEQ_S_OP",	333,
	"Y_C_ULE_D_OP",	334,
	"Y_C_ULE_S_OP",	335,
	"Y_C_UN_D_OP",	336,
	"Y_C_UN_S_OP",	337,
	"Y_DIVU_OP",	338,
	"Y_DIV_D_OP",	339,
	"Y_DIV_OP",	340,
	"Y_DIV_S_OP",	341,
	"Y_JALR_OP",	342,
	"Y_JAL_OP",	343,
	"Y_JR_OP",	344,
	"Y_J_OP",	345,
	"Y_LBU_OP",	346,
	"Y_LB_OP",	347,
	"Y_LHU_OP",	348,
	"Y_LH_OP",	349,
	"Y_LUI_OP",	350,
	"Y_LWC0_OP",	351,
	"Y_LWC1_OP",	352,
	"Y_LWC2_OP",	353,
	"Y_LWC3_OP",	354,
	"Y_LWL_OP",	355,
	"Y_LWR_OP",	356,
	"Y_LW_OP",	357,
	"Y_MFC0_OP",	358,
	"Y_MFC1_OP",	359,
	"Y_MFC2_OP",	360,
	"Y_MFC3_OP",	361,
	"Y_MFHI_OP",	362,
	"Y_MFLO_OP",	363,
	"Y_MOV_D_OP",	364,
	"Y_MOV_S_OP",	365,
	"Y_MTC0_OP",	366,
	"Y_MTC1_OP",	367,
	"Y_MTC2_OP",	368,
	"Y_MTC3_OP",	369,
	"Y_MTHI_OP",	370,
	"Y_MTLO_OP",	371,
	"Y_MULTU_OP",	372,
	"Y_MULT_OP",	373,
	"Y_MUL_D_OP",	374,
	"Y_MUL_S_OP",	375,
	"Y_NEG_D_OP",	376,
	"Y_NEG_S_OP",	377,
	"Y_NOR_OP",	378,
	"Y_ORI_OP",	379,
	"Y_OR_OP",	380,
	"Y_PFW_OP",	381,
	"Y_RFE_OP",	382,
	"Y_SB_OP",	383,
	"Y_SH_OP",	384,
	"Y_SLLV_OP",	385,
	"Y_SLL_OP",	386,
	"Y_SLTIU_OP",	387,
	"Y_SLTI_OP",	388,
	"Y_SLTU_OP",	389,
	"Y_SLT_OP",	390,
	"Y_SRAV_OP",	391,
	"Y_SRA_OP",	392,
	"Y_SRLV_OP",	393,
	"Y_SRL_OP",	394,
	"Y_SUBU_OP",	395,
	"Y_SUB_D_OP",	396,
	"Y_SUB_OP",	397,
	"Y_SUB_S_OP",	398,
	"Y_SWC0_OP",	399,
	"Y_SWC1_OP",	400,
	"Y_SWC2_OP",	401,
	"Y_SWC3_OP",	402,
	"Y_SWL_OP",	403,
	"Y_SWR_OP",	404,
	"Y_SW_OP",	405,
	"Y_SYSCALL_OP",	406,
	"Y_TLBP_OP",	407,
	"Y_TLBR_OP",	408,
	"Y_TLBWI_OP",	409,
	"Y_TLBWR_OP",	410,
	"Y_XORI_OP",	411,
	"Y_XOR_OP",	412,
	"Y_ABS_POP",	413,
	"Y_BAL_POP",	414,
	"Y_BEQZ_POP",	415,
	"Y_BGEU_POP",	416,
	"Y_BGE_POP",	417,
	"Y_BGTU_POP",	418,
	"Y_BGT_POP",	419,
	"Y_BLEU_POP",	420,
	"Y_BLE_POP",	421,
	"Y_BLTU_POP",	422,
	"Y_BLT_POP",	423,
	"Y_BNEZ_POP",	424,
	"Y_B_POP",	425,
	"Y_LA_POP",	426,
	"Y_LD_POP",	427,
	"Y_LI_POP",	428,
	"Y_LI_D_POP",	429,
	"Y_LI_S_POP",	430,
	"Y_L_D_POP",	431,
	"Y_L_S_POP",	432,
	"Y_MFC1_D_POP",	433,
	"Y_MTC1_D_POP",	434,
	"Y_MOVE_POP",	435,
	"Y_MULOU_POP",	436,
	"Y_MULO_POP",	437,
	"Y_MUL_POP",	438,
	"Y_NEGU_POP",	439,
	"Y_NEG_POP",	440,
	"Y_NOP_POP",	441,
	"Y_NOT_POP",	442,
	"Y_REMU_POP",	443,
	"Y_REM_POP",	444,
	"Y_ROL_POP",	445,
	"Y_ROR_POP",	446,
	"Y_SD_POP",	447,
	"Y_SEQ_POP",	448,
	"Y_SGEU_POP",	449,
	"Y_SGE_POP",	450,
	"Y_SGTU_POP",	451,
	"Y_SGT_POP",	452,
	"Y_SLEU_POP",	453,
	"Y_SLE_POP",	454,
	"Y_SNE_POP",	455,
	"Y_S_D_POP",	456,
	"Y_S_S_POP",	457,
	"Y_ULHU_POP",	458,
	"Y_ULH_POP",	459,
	"Y_ULW_POP",	460,
	"Y_USH_POP",	461,
	"Y_USW_POP",	462,
	"Y_ALIAS_DIR",	463,
	"Y_ALIGN_DIR",	464,
	"Y_ASCII_DIR",	465,
	"Y_ASCIIZ_DIR",	466,
	"Y_ASM0_DIR",	467,
	"Y_BGNB_DIR",	468,
	"Y_BYTE_DIR",	469,
	"Y_COMM_DIR",	470,
	"Y_DATA_DIR",	471,
	"Y_DOUBLE_DIR",	472,
	"Y_ENDB_DIR",	473,
	"Y_ENDR_DIR",	474,
	"Y_END_DIR",	475,
	"Y_ENT_DIR",	476,
	"Y_ERR_DIR",	477,
	"Y_EXTERN_DIR",	478,
	"Y_FILE_DIR",	479,
	"Y_FLOAT_DIR",	480,
	"Y_FMASK_DIR",	481,
	"Y_FRAME_DIR",	482,
	"Y_GLOBAL_DIR",	483,
	"Y_HALF_DIR",	484,
	"Y_K_TEXT_DIR",	485,
	"Y_K_DATA_DIR",	486,
	"Y_LABEL_DIR",	487,
	"Y_LCOMM_DIR",	488,
	"Y_LIVEREG_DIR",	489,
	"Y_LOC_DIR",	490,
	"Y_MASK_DIR",	491,
	"Y_NOALIAS_DIR",	492,
	"Y_OPTIONS_DIR",	493,
	"Y_RDATA_DIR",	494,
	"Y_REPEAT_DIR",	495,
	"Y_SDATA_DIR",	496,
	"Y_SET_DIR",	497,
	"Y_SPACE_DIR",	498,
	"Y_STRUCT_DIR",	499,
	"Y_TEXT_DIR",	500,
	"Y_VERSTAMP_DIR",	501,
	"Y_VREG_DIR",	502,
	"Y_WORD_DIR",	503,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"LINE : /* empty */",
	"LINE : OPT_LBL CMD",
	"OPT_LBL : ID ':'",
	"OPT_LBL : ID '=' Y_INT",
	"OPT_LBL : /* empty */",
	"CMD : ASM_CODE Y_NL",
	"CMD : ASM_DIRECTIVE Y_NL",
	"CMD : Y_NL",
	"CMD : Y_EOF",
	"ASM_CODE : LOAD_OP DEST_REG ADDRESS",
	"ASM_CODE : LOAD_COP COP_REG ADDRESS",
	"ASM_CODE : LOAD_IMM_OP DEST_REG IMM",
	"ASM_CODE : Y_LA_POP DEST_REG ADDRESS",
	"ASM_CODE : Y_LI_POP DEST_REG IMM",
	"ASM_CODE : Y_LI_D_POP F_DEST Y_FP",
	"ASM_CODE : Y_LI_S_POP F_DEST Y_FP",
	"ASM_CODE : Y_ULW_POP DEST_REG ADDRESS",
	"ASM_CODE : ULOADH_POP DEST_REG ADDRESS",
	"ASM_CODE : LOADF_OP F_DEST ADDRESS",
	"ASM_CODE : STORE_OP SOURCE ADDRESS",
	"ASM_CODE : STORE_COP COP_REG ADDRESS",
	"ASM_CODE : Y_USW_POP SOURCE ADDRESS",
	"ASM_CODE : Y_USH_POP SOURCE ADDRESS",
	"ASM_CODE : STOREF_OP F_SRC1 ADDRESS",
	"ASM_CODE : SYS_OP",
	"ASM_CODE : Y_BREAK_OP Y_INT",
	"ASM_CODE : Y_NOP_POP",
	"ASM_CODE : Y_ABS_POP DEST_REG SRC1",
	"ASM_CODE : Y_NEG_POP DEST_REG SRC1",
	"ASM_CODE : Y_NEGU_POP DEST_REG SRC1",
	"ASM_CODE : Y_NOT_POP DEST_REG SRC1",
	"ASM_CODE : Y_MOVE_POP DEST_REG SRC1",
	"ASM_CODE : BINARY_OP_I DEST_REG SRC1 SRC2",
	"ASM_CODE : BINARY_OP_I DEST_REG SRC1 IMM",
	"ASM_CODE : BINARY_OP_I DEST_REG IMM",
	"ASM_CODE : BINARY_OPR_I DEST_REG SRC1 SRC2",
	"ASM_CODE : BINARY_OPR_I DEST_REG SRC1 Y_INT",
	"ASM_CODE : BINARY_OPR_I DEST_REG Y_INT",
	"ASM_CODE : BINARY_IMM_OP DEST_REG SRC1 IMM",
	"ASM_CODE : BINARY_IMM_OP DEST_REG IMM",
	"ASM_CODE : SHIFT_OP DEST_REG SRC1 Y_INT",
	"ASM_CODE : SHIFT_OP DEST_REG SRC1 SRC2",
	"ASM_CODE : BINARY_OP_NOI DEST_REG SRC1 SRC2",
	"ASM_CODE : BINARY_OP_NOI DEST_REG SRC1 IMM",
	"ASM_CODE : BINARY_OP_NOI DEST_REG IMM",
	"ASM_CODE : SUB_OP DEST_REG SRC1 SRC2",
	"ASM_CODE : SUB_OP DEST_REG SRC1 IMM",
	"ASM_CODE : SUB_OP DEST_REG IMM",
	"ASM_CODE : DIV_POP DEST_REG SRC1",
	"ASM_CODE : DIV_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : DIV_POP DEST_REG SRC1 IMM",
	"ASM_CODE : MUL_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : MUL_POP DEST_REG SRC1 IMM",
	"ASM_CODE : MULT_OP SRC1 SRC2",
	"ASM_CODE : Y_ROR_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : Y_ROL_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : Y_ROR_POP DEST_REG SRC1 IMM",
	"ASM_CODE : Y_ROL_POP DEST_REG SRC1 IMM",
	"ASM_CODE : SET_LE_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : SET_LE_POP DEST_REG SRC1 IMM",
	"ASM_CODE : SET_GT_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : SET_GT_POP DEST_REG SRC1 IMM",
	"ASM_CODE : SET_GE_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : SET_GE_POP DEST_REG SRC1 IMM",
	"ASM_CODE : SET_EQ_POP DEST_REG SRC1 SRC2",
	"ASM_CODE : SET_EQ_POP DEST_REG SRC1 IMM",
	"ASM_CODE : NULLARY_BR_OP LABEL",
	"ASM_CODE : UNARY_BR_OP SRC1 LABEL",
	"ASM_CODE : UNARY_BR_POP SRC1 LABEL",
	"ASM_CODE : BINARY_BR_OP SRC1 SRC2 LABEL",
	"ASM_CODE : BINARY_BR_OP SRC1 IMMEDIATE LABEL",
	"ASM_CODE : BR_GT_POP SRC1 SRC2 LABEL",
	"ASM_CODE : BR_GT_POP SRC1 IMMEDIATE LABEL",
	"ASM_CODE : BR_GE_POP SRC1 SRC2 LABEL",
	"ASM_CODE : BR_GE_POP SRC1 IMMEDIATE LABEL",
	"ASM_CODE : BR_LT_POP SRC1 SRC2 LABEL",
	"ASM_CODE : BR_LT_POP SRC1 IMMEDIATE LABEL",
	"ASM_CODE : BR_LE_POP SRC1 SRC2 LABEL",
	"ASM_CODE : BR_LE_POP SRC1 IMMEDIATE LABEL",
	"ASM_CODE : J_OPS LABEL",
	"ASM_CODE : J_OPS SRC1",
	"ASM_CODE : J_OPS DEST SRC1",
	"ASM_CODE : B_OP LABEL",
	"ASM_CODE : MOVE_COP_OP COP_REG COP_REG",
	"ASM_CODE : MOV_FROM_HILO_OP REG",
	"ASM_CODE : MOV_TO_HILO_OP REG",
	"ASM_CODE : MOV_COP_OP REG COP_REG",
	"ASM_CODE : CTL_COP_OP COP_REG COP_REG",
	"ASM_CODE : FP_ABS_OP F_DEST F_SRC1",
	"ASM_CODE : FP_BINARY_OP F_DEST F_SRC1 F_SRC2",
	"ASM_CODE : FP_CONVERT_OP F_DEST F_SRC2",
	"ASM_CODE : FP_NEG_OP F_DEST F_SRC2",
	"ASM_CODE : FP_CMP_OP F_SRC1 F_SRC2",
	"LOAD_OP : Y_LB_OP",
	"LOAD_OP : Y_LBU_OP",
	"LOAD_OP : Y_LH_OP",
	"LOAD_OP : Y_LHU_OP",
	"LOAD_OP : Y_LW_OP",
	"LOAD_OP : Y_LWL_OP",
	"LOAD_OP : Y_LWR_OP",
	"LOAD_OP : Y_LD_POP",
	"LOAD_OP : Y_PFW_OP",
	"LOAD_COP : Y_LWC0_OP",
	"LOAD_COP : Y_LWC2_OP",
	"LOAD_COP : Y_LWC3_OP",
	"LOAD_IMM_OP : Y_LUI_OP",
	"ULOADH_POP : Y_ULH_POP",
	"ULOADH_POP : Y_ULHU_POP",
	"LOADF_OP : Y_LWC1_OP",
	"LOADF_OP : Y_L_S_POP",
	"LOADF_OP : Y_L_D_POP",
	"STORE_OP : Y_SB_OP",
	"STORE_OP : Y_SH_OP",
	"STORE_OP : Y_SW_OP",
	"STORE_OP : Y_SWL_OP",
	"STORE_OP : Y_SWR_OP",
	"STORE_OP : Y_SD_POP",
	"STORE_COP : Y_SWC0_OP",
	"STORE_COP : Y_SWC2_OP",
	"STORE_COP : Y_SWC3_OP",
	"STOREF_OP : Y_SWC1_OP",
	"STOREF_OP : Y_S_S_POP",
	"STOREF_OP : Y_S_D_POP",
	"SYS_OP : Y_RFE_OP",
	"SYS_OP : Y_SYSCALL_OP",
	"BINARY_OP_I : Y_ADD_OP",
	"BINARY_OP_I : Y_ADDU_OP",
	"BINARY_OP_I : Y_AND_OP",
	"BINARY_OP_I : Y_XOR_OP",
	"BINARY_OP_I : Y_OR_OP",
	"BINARY_OP_I : Y_SLT_OP",
	"BINARY_OP_I : Y_SLTU_OP",
	"BINARY_OPR_I : Y_SLLV_OP",
	"BINARY_OPR_I : Y_SRAV_OP",
	"BINARY_OPR_I : Y_SRLV_OP",
	"BINARY_IMM_OP : Y_ADDI_OP",
	"BINARY_IMM_OP : Y_ADDIU_OP",
	"BINARY_IMM_OP : Y_ANDI_OP",
	"BINARY_IMM_OP : Y_ORI_OP",
	"BINARY_IMM_OP : Y_XORI_OP",
	"BINARY_IMM_OP : Y_SLTI_OP",
	"BINARY_IMM_OP : Y_SLTIU_OP",
	"SHIFT_OP : Y_SLL_OP",
	"SHIFT_OP : Y_SRA_OP",
	"SHIFT_OP : Y_SRL_OP",
	"BINARY_OP_NOI : Y_NOR_OP",
	"SUB_OP : Y_SUB_OP",
	"SUB_OP : Y_SUBU_OP",
	"DIV_POP : Y_DIV_OP",
	"DIV_POP : Y_DIVU_OP",
	"DIV_POP : Y_REM_POP",
	"DIV_POP : Y_REMU_POP",
	"MUL_POP : Y_MUL_POP",
	"MUL_POP : Y_MULO_POP",
	"MUL_POP : Y_MULOU_POP",
	"SET_LE_POP : Y_SLE_POP",
	"SET_LE_POP : Y_SLEU_POP",
	"SET_GT_POP : Y_SGT_POP",
	"SET_GT_POP : Y_SGTU_POP",
	"SET_GE_POP : Y_SGE_POP",
	"SET_GE_POP : Y_SGEU_POP",
	"SET_EQ_POP : Y_SEQ_POP",
	"SET_EQ_POP : Y_SNE_POP",
	"MULT_OP : Y_MULT_OP",
	"MULT_OP : Y_MULTU_OP",
	"NULLARY_BR_OP : Y_BC0T_OP",
	"NULLARY_BR_OP : Y_BC1T_OP",
	"NULLARY_BR_OP : Y_BC2T_OP",
	"NULLARY_BR_OP : Y_BC3T_OP",
	"NULLARY_BR_OP : Y_BC0F_OP",
	"NULLARY_BR_OP : Y_BC1F_OP",
	"NULLARY_BR_OP : Y_BC2F_OP",
	"NULLARY_BR_OP : Y_BC3F_OP",
	"UNARY_BR_OP : Y_BGEZ_OP",
	"UNARY_BR_OP : Y_BGEZAL_OP",
	"UNARY_BR_OP : Y_BGTZ_OP",
	"UNARY_BR_OP : Y_BLEZ_OP",
	"UNARY_BR_OP : Y_BLTZ_OP",
	"UNARY_BR_OP : Y_BLTZAL_OP",
	"UNARY_BR_POP : Y_BEQZ_POP",
	"UNARY_BR_POP : Y_BNEZ_POP",
	"BINARY_BR_OP : Y_BEQ_OP",
	"BINARY_BR_OP : Y_BNE_OP",
	"BR_GT_POP : Y_BGT_POP",
	"BR_GT_POP : Y_BGTU_POP",
	"BR_GE_POP : Y_BGE_POP",
	"BR_GE_POP : Y_BGEU_POP",
	"BR_LT_POP : Y_BLT_POP",
	"BR_LT_POP : Y_BLTU_POP",
	"BR_LE_POP : Y_BLE_POP",
	"BR_LE_POP : Y_BLEU_POP",
	"J_OPS : Y_J_OP",
	"J_OPS : Y_JR_OP",
	"J_OPS : Y_JAL_OP",
	"J_OPS : Y_JALR_OP",
	"B_OP : Y_B_POP",
	"B_OP : Y_BAL_POP",
	"MOVE_COP_OP : Y_MOV_S_OP",
	"MOVE_COP_OP : Y_MOV_D_OP",
	"MOV_FROM_HILO_OP : Y_MFHI_OP",
	"MOV_FROM_HILO_OP : Y_MFLO_OP",
	"MOV_TO_HILO_OP : Y_MTHI_OP",
	"MOV_TO_HILO_OP : Y_MTLO_OP",
	"MOV_COP_OP : Y_MFC0_OP",
	"MOV_COP_OP : Y_MFC1_OP",
	"MOV_COP_OP : Y_MFC1_D_POP",
	"MOV_COP_OP : Y_MFC2_OP",
	"MOV_COP_OP : Y_MFC3_OP",
	"MOV_COP_OP : Y_MTC0_OP",
	"MOV_COP_OP : Y_MTC1_OP",
	"MOV_COP_OP : Y_MTC1_D_POP",
	"MOV_COP_OP : Y_MTC2_OP",
	"MOV_COP_OP : Y_MTC3_OP",
	"CTL_COP_OP : Y_CFC0_OP",
	"CTL_COP_OP : Y_CFC1_OP",
	"CTL_COP_OP : Y_CFC2_OP",
	"CTL_COP_OP : Y_CFC3_OP",
	"CTL_COP_OP : Y_CTC0_OP",
	"CTL_COP_OP : Y_CTC1_OP",
	"CTL_COP_OP : Y_CTC2_OP",
	"CTL_COP_OP : Y_CTC3_OP",
	"FP_ABS_OP : Y_ABS_S_OP",
	"FP_ABS_OP : Y_ABS_D_OP",
	"FP_BINARY_OP : Y_ADD_S_OP",
	"FP_BINARY_OP : Y_ADD_D_OP",
	"FP_BINARY_OP : Y_DIV_S_OP",
	"FP_BINARY_OP : Y_DIV_D_OP",
	"FP_BINARY_OP : Y_MUL_S_OP",
	"FP_BINARY_OP : Y_MUL_D_OP",
	"FP_BINARY_OP : Y_SUB_S_OP",
	"FP_BINARY_OP : Y_SUB_D_OP",
	"FP_CONVERT_OP : Y_CVT_D_S_OP",
	"FP_CONVERT_OP : Y_CVT_D_W_OP",
	"FP_CONVERT_OP : Y_CVT_S_D_OP",
	"FP_CONVERT_OP : Y_CVT_S_W_OP",
	"FP_CONVERT_OP : Y_CVT_W_D_OP",
	"FP_CONVERT_OP : Y_CVT_W_S_OP",
	"FP_NEG_OP : Y_NEG_S_OP",
	"FP_NEG_OP : Y_NEG_D_OP",
	"FP_CMP_OP : Y_C_F_S_OP",
	"FP_CMP_OP : Y_C_UN_S_OP",
	"FP_CMP_OP : Y_C_EQ_S_OP",
	"FP_CMP_OP : Y_C_UEQ_S_OP",
	"FP_CMP_OP : Y_C_OLE_S_OP",
	"FP_CMP_OP : Y_C_ULE_S_OP",
	"FP_CMP_OP : Y_C_SF_S_OP",
	"FP_CMP_OP : Y_C_NGLE_S_OP",
	"FP_CMP_OP : Y_C_SEQ_S_OP",
	"FP_CMP_OP : Y_C_NGL_S_OP",
	"FP_CMP_OP : Y_C_LT_S_OP",
	"FP_CMP_OP : Y_C_NGE_S_OP",
	"FP_CMP_OP : Y_C_LE_S_OP",
	"FP_CMP_OP : Y_C_NGT_S_OP",
	"FP_CMP_OP : Y_C_F_D_OP",
	"FP_CMP_OP : Y_C_UN_D_OP",
	"FP_CMP_OP : Y_C_EQ_D_OP",
	"FP_CMP_OP : Y_C_UEQ_D_OP",
	"FP_CMP_OP : Y_C_OLE_D_OP",
	"FP_CMP_OP : Y_C_ULE_D_OP",
	"FP_CMP_OP : Y_C_SF_D_OP",
	"FP_CMP_OP : Y_C_NGLE_D_OP",
	"FP_CMP_OP : Y_C_SEQ_D_OP",
	"FP_CMP_OP : Y_C_NGL_D_OP",
	"FP_CMP_OP : Y_C_LT_D_OP",
	"FP_CMP_OP : Y_C_NGE_D_OP",
	"FP_CMP_OP : Y_C_LE_D_OP",
	"FP_CMP_OP : Y_C_NGT_D_OP",
	"ASM_DIRECTIVE : Y_ALIAS_DIR Y_REG Y_REG",
	"ASM_DIRECTIVE : Y_ALIGN_DIR EXPR",
	"ASM_DIRECTIVE : Y_ASCII_DIR",
	"ASM_DIRECTIVE : Y_ASCII_DIR STR_LST",
	"ASM_DIRECTIVE : Y_ASCIIZ_DIR",
	"ASM_DIRECTIVE : Y_ASCIIZ_DIR STR_LST",
	"ASM_DIRECTIVE : Y_ASM0_DIR",
	"ASM_DIRECTIVE : Y_BGNB_DIR Y_INT",
	"ASM_DIRECTIVE : Y_BYTE_DIR",
	"ASM_DIRECTIVE : Y_BYTE_DIR EXPR_LST",
	"ASM_DIRECTIVE : Y_COMM_DIR ID EXPR",
	"ASM_DIRECTIVE : Y_DATA_DIR",
	"ASM_DIRECTIVE : Y_DATA_DIR Y_INT",
	"ASM_DIRECTIVE : Y_K_DATA_DIR",
	"ASM_DIRECTIVE : Y_K_DATA_DIR Y_INT",
	"ASM_DIRECTIVE : Y_DOUBLE_DIR",
	"ASM_DIRECTIVE : Y_DOUBLE_DIR FP_EXPR_LST",
	"ASM_DIRECTIVE : Y_END_DIR OPTIONAL_ID",
	"ASM_DIRECTIVE : Y_ENDB_DIR Y_INT",
	"ASM_DIRECTIVE : Y_ENDR_DIR",
	"ASM_DIRECTIVE : Y_ENT_DIR ID",
	"ASM_DIRECTIVE : Y_ENT_DIR ID Y_INT",
	"ASM_DIRECTIVE : Y_EXTERN_DIR ID EXPR",
	"ASM_DIRECTIVE : Y_ERR_DIR",
	"ASM_DIRECTIVE : Y_FILE_DIR Y_INT Y_STR",
	"ASM_DIRECTIVE : Y_FLOAT_DIR",
	"ASM_DIRECTIVE : Y_FLOAT_DIR FP_EXPR_LST",
	"ASM_DIRECTIVE : Y_FMASK_DIR Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_FRAME_DIR REGISTER Y_INT REGISTER",
	"ASM_DIRECTIVE : Y_GLOBAL_DIR ID",
	"ASM_DIRECTIVE : Y_HALF_DIR",
	"ASM_DIRECTIVE : Y_HALF_DIR EXPR_LST",
	"ASM_DIRECTIVE : Y_LABEL_DIR ID",
	"ASM_DIRECTIVE : Y_LCOMM_DIR ID EXPR",
	"ASM_DIRECTIVE : Y_LIVEREG_DIR Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_LOC_DIR Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_MASK_DIR Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_NOALIAS_DIR Y_REG Y_REG",
	"ASM_DIRECTIVE : Y_OPTIONS_DIR ID",
	"ASM_DIRECTIVE : Y_REPEAT_DIR EXPR",
	"ASM_DIRECTIVE : Y_RDATA_DIR",
	"ASM_DIRECTIVE : Y_RDATA_DIR Y_INT",
	"ASM_DIRECTIVE : Y_SDATA_DIR",
	"ASM_DIRECTIVE : Y_SDATA_DIR Y_INT",
	"ASM_DIRECTIVE : Y_SET_DIR ID",
	"ASM_DIRECTIVE : Y_SPACE_DIR EXPR",
	"ASM_DIRECTIVE : Y_STRUCT_DIR EXPR",
	"ASM_DIRECTIVE : Y_TEXT_DIR",
	"ASM_DIRECTIVE : Y_TEXT_DIR Y_INT",
	"ASM_DIRECTIVE : Y_K_TEXT_DIR",
	"ASM_DIRECTIVE : Y_K_TEXT_DIR Y_INT",
	"ASM_DIRECTIVE : Y_VERSTAMP_DIR Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_VREG_DIR REGISTER Y_INT Y_INT",
	"ASM_DIRECTIVE : Y_WORD_DIR",
	"ASM_DIRECTIVE : Y_WORD_DIR EXPR_LST",
	"ADDRESS : /* empty */",
	"ADDRESS : ADDR",
	"ADDR : '(' REGISTER ')'",
	"ADDR : ABS_ADDR",
	"ADDR : ABS_ADDR '(' REGISTER ')'",
	"ADDR : Y_ID",
	"ADDR : Y_ID '(' REGISTER ')'",
	"ADDR : Y_ID '+' ABS_ADDR",
	"ADDR : ABS_ADDR '+' ID",
	"ADDR : Y_ID '-' ABS_ADDR",
	"ADDR : Y_ID '+' ABS_ADDR '(' REGISTER ')'",
	"ADDR : Y_ID '-' ABS_ADDR '(' REGISTER ')'",
	"IMMEDIATE : /* empty */",
	"IMMEDIATE : IMM",
	"IMM : ABS_ADDR",
	"IMM : '(' ABS_ADDR ')' '>' '>' Y_INT",
	"IMM : ID",
	"IMM : Y_ID '+' ABS_ADDR",
	"IMM : Y_ID '-' ABS_ADDR",
	"ABS_ADDR : Y_INT",
	"ABS_ADDR : Y_INT '+' Y_INT",
	"ABS_ADDR : Y_INT Y_INT",
	"DEST_REG : REGISTER",
	"SRC1 : REGISTER",
	"SRC2 : REGISTER",
	"DEST : REGISTER",
	"REG : REGISTER",
	"SOURCE : REGISTER",
	"REGISTER : Y_REG",
	"F_DEST : FP_REGISTER",
	"F_SRC1 : FP_REGISTER",
	"F_SRC2 : FP_REGISTER",
	"FP_REGISTER : Y_FP_REG",
	"COP_REG : Y_REG",
	"COP_REG : Y_FP_REG",
	"LABEL : ID",
	"STR_LST : STR_LST STR",
	"STR_LST : STR",
	"STR : Y_STR",
	"STR : Y_STR ':' Y_INT",
	"EXPRESSION : /* empty */",
	"EXPRESSION : EXPR",
	"EXPR : Y_INT",
	"EXPR : ID",
	"EXPR_LST : EXPR_LST EXPRESSION",
	"EXPR_LST : EXPRESSION",
	"EXPR_LST : EXPRESSION ':' Y_INT",
	"FP_EXPR_LST : FP_EXPR_LST Y_FP",
	"FP_EXPR_LST : Y_FP",
	"OPTIONAL_ID : /* empty */",
	"OPTIONAL_ID : OPT_ID",
	"OPT_ID : ID",
	"OPT_ID : /* empty */",
	"ID : /* empty */",
	"ID : Y_ID",
};
#endif /* YYDEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	{ free(yys); free(yyv); return(0); }
#define YYABORT		{ free(yys); free(yyv); return(1); }
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** static variables used by the parser
*/
static YYSTYPE *yyv;			/* value stack */
static int *yys;			/* state stack */

static YYSTYPE *yypv;			/* top of value stack */
static int *yyps;			/* top of state stack */

static int yystate;			/* current state */
static int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */

int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */
	unsigned yymaxdepth = YYMAXDEPTH;

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yyv = (YYSTYPE*)malloc(yymaxdepth*sizeof(YYSTYPE));
	yys = (int*)malloc(yymaxdepth*sizeof(int));
	if (!yyv || !yys)
	{
		yyerror( "out of memory" );
		return(1);
	}
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			(void)printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			yymaxdepth += YYMAXDEPTH;
			yyv = (YYSTYPE*)realloc((char*)yyv,
				yymaxdepth * sizeof(YYSTYPE));
			yys = (int*)realloc((char*)yys,
				yymaxdepth * sizeof(int));
			if (!yyv || !yys)
			{
				yyerror( "yacc stack overflow" );
				return(1);
			}
			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			(void)printf( "Received token " );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				(void)printf( "Received token " );
				if ( yychar == 0 )
					(void)printf( "end-of-file\n" );
				else if ( yychar < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					(void)printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						(void)printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					(void)printf( "Error recovery discards " );
					if ( yychar == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 366 "parser.y"
{scanner_start_line ();} break;
case 3:
# line 369 "parser.y"
{
			   this_line_labels =
			     cons_label (record_label
					 ((char *)yypvt[-1],
					  (text_dir ? current_text_pc ()
					   : current_data_pc ())),
					 this_line_labels);
			 } break;
case 4:
# line 379 "parser.y"
{
		  label *l = record_label ((char *) yypvt[-2], (mem_addr) yypvt[-0]);

		  l->const_flag = 1;
		  clear_labels ();
		} break;
case 5:
# line 387 "parser.y"
{} break;
case 6:
# line 392 "parser.y"
{
		  clear_labels ();
		  return (1);
		} break;
case 7:
# line 398 "parser.y"
{
		  clear_labels ();
		  return (1);
		} break;
case 8:
# line 404 "parser.y"
{
		  return (1);
		} break;
case 9:
# line 409 "parser.y"
{
		  clear_labels ();
		  return (0);
		} break;
case 10:
# line 418 "parser.y"
{
		  i_type_inst (yypvt[-2] == Y_LD_POP ? Y_LW_OP : yypvt[-2],
			       yypvt[-1],
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       addr_expr_imm ((addr_expr *)yypvt[-0]));
		  if (yypvt[-2] == Y_LD_POP)
		    i_type_inst (Y_LW_OP,
				 yypvt[-1] + 1,
				 addr_expr_reg ((addr_expr *)yypvt[-0]),
				 incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0]),
						   4));
		  free ((addr_expr *)yypvt[-0]);
		} break;
case 11:
# line 433 "parser.y"
{
		  i_type_inst (yypvt[-2], yypvt[-1], addr_expr_reg ((addr_expr *)yypvt[-0]),
			       addr_expr_imm ((addr_expr *)yypvt[-0]));
		  free ((addr_expr *)yypvt[-0]);
		} break;
case 12:
# line 440 "parser.y"
{
		  i_type_inst (yypvt[-2], yypvt[-1], 0, (imm_expr *)yypvt[-0]);
		} break;
case 13:
# line 446 "parser.y"
{
		  if (addr_expr_reg ((addr_expr *)yypvt[-0]))
		    i_type_inst (Y_ADDI_OP, yypvt[-1],
				 addr_expr_reg ((addr_expr *)yypvt[-0]),
				 addr_expr_imm ((addr_expr *)yypvt[-0]));
		  else
		    i_type_inst (Y_LUI_OP, yypvt[-1], 0,
				 addr_expr_imm ((addr_expr *)yypvt[-0]));
		  free ((addr_expr *)yypvt[-0]);
		} break;
case 14:
# line 459 "parser.y"
{
		  i_type_inst (Y_ORI_OP, yypvt[-1], 0, (imm_expr *)yypvt[-0]);
		} break;
case 15:
# line 465 "parser.y"
{
		  int *x = (int *) yypvt[-0];

		  i_type_inst (Y_ORI_OP, 1, 0, const_imm_expr (*x));
		  r_type_inst (Y_MTC1_OP, yypvt[-1], 0, 1);
		  i_type_inst (Y_ORI_OP, 1, 0, const_imm_expr (*(x+1)));
		  r_type_inst (Y_MTC1_OP, yypvt[-1] + 1, 0, 1);
		} break;
case 16:
# line 476 "parser.y"
{
		  float x = * ((double *) yypvt[-0]);
		  int *y = (int *) &x;

		  i_type_inst (Y_ORI_OP, 1, 0, const_imm_expr (*y));
		  r_type_inst (Y_MTC1_OP, yypvt[-1], 0, 1);
		} break;
case 17:
# line 486 "parser.y"
{
#ifdef BIGENDIAN
		  i_type_inst (Y_LWL_OP, yypvt[-1],
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       addr_expr_imm ((addr_expr *)yypvt[-0]));
		  i_type_inst (Y_LWR_OP, yypvt[-1],
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0]),
						 3));
#else
		  i_type_inst (Y_LWL_OP, yypvt[-1],
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0]),
						 3));
		  i_type_inst (Y_LWR_OP, yypvt[-1],
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       addr_expr_imm ((addr_expr *)yypvt[-0]));
#endif
		  free ((addr_expr *)yypvt[-0]);
		} break;
case 18:
# line 509 "parser.y"
{
#ifdef BIGENDIAN
		  i_type_inst ((yypvt[-2] == Y_ULH_POP ? Y_LB_OP : Y_LBU_OP),
			       yypvt[-1],
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       addr_expr_imm ((addr_expr *)yypvt[-0]));
		  i_type_inst (Y_LBU_OP, 1,
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0]),
						 1));
#else
		  i_type_inst ((yypvt[-2] == Y_ULH_POP ? Y_LB_OP : Y_LBU_OP),
			       yypvt[-1],
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0]),
						 1));
		  i_type_inst (Y_LBU_OP, 1,
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       addr_expr_imm ((addr_expr *)yypvt[-0]));
#endif
		  r_sh_type_inst (Y_SLL_OP, yypvt[-1], yypvt[-1], 8);
		  r_type_inst (Y_OR_OP, yypvt[-1], yypvt[-1], 1);
		  free ((addr_expr *)yypvt[-0]);
		} break;
case 19:
# line 536 "parser.y"
{
		  i_type_inst (Y_LWC1_OP, yypvt[-1],
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       addr_expr_imm ((addr_expr *)yypvt[-0]));
		  if (yypvt[-2] == Y_L_D_POP)
		    i_type_inst (Y_LWC1_OP, yypvt[-1] + 1,
				 addr_expr_reg ((addr_expr *)yypvt[-0]),
				 incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0]),
						   4));
		  free ((addr_expr *)yypvt[-0]);
		} break;
case 20:
# line 550 "parser.y"
{
		  i_type_inst (yypvt[-2] == Y_SD_POP ? Y_SW_OP : yypvt[-2],
			       yypvt[-1],
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       addr_expr_imm ((addr_expr *)yypvt[-0]));
		  if (yypvt[-2] == Y_SD_POP)
		    i_type_inst (Y_SW_OP, yypvt[-1] + 1,
				 addr_expr_reg ((addr_expr *)yypvt[-0]),
				 incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0]),
						   4));
		  free ((addr_expr *)yypvt[-0]);
		} break;
case 21:
# line 565 "parser.y"
{
		  i_type_inst (yypvt[-2], yypvt[-1],
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       addr_expr_imm ((addr_expr *)yypvt[-0]));
		  free ((addr_expr *)yypvt[-0]);
		} break;
case 22:
# line 574 "parser.y"
{
#ifdef BIGENDIAN
		  i_type_inst (Y_SWL_OP, yypvt[-1],
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       addr_expr_imm ((addr_expr *)yypvt[-0]));
		  i_type_inst (Y_SWR_OP, yypvt[-1],
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0]),
						 3));
#else
		  i_type_inst (Y_SWL_OP, yypvt[-1],
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0]),
						 3));
		  i_type_inst (Y_SWR_OP, yypvt[-1],
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       addr_expr_imm ((addr_expr *)yypvt[-0]));
#endif
		  free ((addr_expr *)yypvt[-0]);
		} break;
case 23:
# line 597 "parser.y"
{
		  i_type_inst (Y_SB_OP, yypvt[-1],
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       addr_expr_imm ((addr_expr *)yypvt[-0]));
		  r_sh_type_inst (Y_SRL_OP, 1, yypvt[-1], 8);
		  i_type_inst (Y_SB_OP, 1,
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0]),
						 1));
		  free ((addr_expr *)yypvt[-0]);
		} break;
case 24:
# line 611 "parser.y"
{
		  i_type_inst (Y_SWC1_OP, yypvt[-1],
			       addr_expr_reg ((addr_expr *)yypvt[-0]),
			       addr_expr_imm ((addr_expr *)yypvt[-0]));
		  if (yypvt[-2] == Y_S_D_POP)
		    i_type_inst (Y_SWC1_OP, yypvt[-1] + 1,
				 addr_expr_reg ((addr_expr *)yypvt[-0]),
				 incr_expr_offset (addr_expr_imm ((addr_expr *)yypvt[-0]),
						   4));
		  free ((addr_expr *)yypvt[-0]);
		} break;
case 25:
# line 625 "parser.y"
{
		  r_type_inst (yypvt[-0], 0, 0, 0);
		} break;
case 26:
# line 631 "parser.y"
{
		  if (yypvt[-0] == 1)
		    yyerror ("Breakpoint 1 is reserved for debugger");
		  r_type_inst (yypvt[-1], yypvt[-0], 0, 0);
		} break;
case 27:
# line 639 "parser.y"
{
		  nop_inst ();
		} break;
case 28:
# line 645 "parser.y"
{
		  if (yypvt[-1] != yypvt[-0])
		    r_type_inst (Y_ADDU_OP, yypvt[-1], 0, yypvt[-0]);

		  i_type_inst (Y_BGEZ_OP, 0, yypvt[-0], branch_offset (2));
		  r_type_inst (Y_SUB_OP, yypvt[-1], 0, yypvt[-0]);
		} break;
case 29:
# line 655 "parser.y"
{
		  r_type_inst (Y_SUB_OP, yypvt[-1], 0, yypvt[-0]);
		} break;
case 30:
# line 661 "parser.y"
{
		  r_type_inst (Y_SUBU_OP, yypvt[-1], 0, yypvt[-0]);
		} break;
case 31:
# line 667 "parser.y"
{
		  r_type_inst (Y_NOR_OP, yypvt[-1], yypvt[-0], 0);
		} break;
case 32:
# line 673 "parser.y"
{
		  r_type_inst (Y_ADDU_OP, yypvt[-1], 0, yypvt[-0]);
		} break;
case 33:
# line 679 "parser.y"
{
		  r_type_inst (yypvt[-3], yypvt[-2], yypvt[-1], yypvt[-0]);
		} break;
case 34:
# line 685 "parser.y"
{
		  i_type_inst (op_to_imm_op (yypvt[-3]), yypvt[-2], yypvt[-1], (imm_expr *)yypvt[-0]);
		} break;
case 35:
# line 691 "parser.y"
{
		  i_type_inst (op_to_imm_op (yypvt[-2]), yypvt[-1], yypvt[-1], (imm_expr *)yypvt[-0]);
		} break;
case 36:
# line 697 "parser.y"
{
		  r_type_inst (yypvt[-3], yypvt[-2], yypvt[-0], yypvt[-1]);
		} break;
case 37:
# line 703 "parser.y"
{
		  r_sh_type_inst (op_to_imm_op (yypvt[-3]), yypvt[-2], yypvt[-1], yypvt[-0]);
		} break;
case 38:
# line 709 "parser.y"
{
		  r_sh_type_inst (op_to_imm_op (yypvt[-2]), yypvt[-1], yypvt[-1], yypvt[-0]);
		} break;
case 39:
# line 715 "parser.y"
{
		  i_type_inst (yypvt[-3], yypvt[-2], yypvt[-1], (imm_expr *)yypvt[-0]);
		} break;
case 40:
# line 721 "parser.y"
{
		  i_type_inst (yypvt[-2], yypvt[-1], yypvt[-1], (imm_expr *)yypvt[-0]);
		} break;
case 41:
# line 727 "parser.y"
{
		  r_sh_type_inst (yypvt[-3], yypvt[-2], yypvt[-1], yypvt[-0]);
		} break;
case 42:
# line 733 "parser.y"
{
		  r_type_inst (imm_op_to_op (yypvt[-3]), yypvt[-2], yypvt[-1], yypvt[-0]);
		} break;
case 43:
# line 739 "parser.y"
{
		  r_type_inst (yypvt[-3], yypvt[-2], yypvt[-1], yypvt[-0]);
		} break;
case 44:
# line 745 "parser.y"
{
		  if (bare_machine)
		    yyerror ("Immediate form not allowed in bare machine");
		  else
		    {
		      if (!zero_imm ((imm_expr *)yypvt[-0]))
			/* Use $at */
			i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0]);
		      r_type_inst (yypvt[-3],
				   yypvt[-2],
				   yypvt[-1],
				   (zero_imm ((imm_expr *)yypvt[-0]) ? 0 : 1));
		    }
		} break;
case 45:
# line 762 "parser.y"
{
		  if (bare_machine)
		    yyerror ("Immediate form not allowed in bare machine");
		  else
		    {
		      if (!zero_imm ((imm_expr *)yypvt[-0]))
			/* Use $at */
			i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0]);
		      r_type_inst (yypvt[-2],
				   yypvt[-1],
				   yypvt[-1],
				   (zero_imm ((imm_expr *)yypvt[-0]) ? 0 : 1));
		    }
		} break;
case 46:
# line 779 "parser.y"
{
		  r_type_inst (yypvt[-3], yypvt[-2], yypvt[-1], yypvt[-0]);
		} break;
case 47:
# line 785 "parser.y"
{
		  int val = eval_imm_expr (yypvt[-0]);

		  if (bare_machine)
		    yyerror ("Immediate form not allowed in bare machine");
		  else
		    i_type_inst (yypvt[-3] == Y_SUB_OP ? Y_ADDI_OP
				 : yypvt[-3] == Y_SUBU_OP ? Y_ADDIU_OP
				 : (fatal_error ("Bad SUB_OP\n"), 0),
				 yypvt[-2],
				 yypvt[-1],
				 make_imm_expr ( -val, NULL, 0));
		} break;
case 48:
# line 801 "parser.y"
{
		  int val = eval_imm_expr (yypvt[-0]);

		  if (bare_machine)
		    yyerror ("Immediate form not allowed in bare machine");
		  else
		    i_type_inst (yypvt[-2] == Y_SUB_OP ? Y_ADDI_OP
				 : yypvt[-2] == Y_SUBU_OP ? Y_ADDIU_OP
				 : (fatal_error ("Bad SUB_OP\n"), 0),
				 yypvt[-1],
				 yypvt[-1],
				 make_imm_expr (-val, NULL, 0));
		} break;
case 49:
# line 817 "parser.y"
{
		  /* The hardware divide operation (ignore 1st arg) */
		  if (yypvt[-2] != Y_DIV_OP && yypvt[-2] != Y_DIVU_OP)
		    yyerror ("Syntax error");
		  r_type_inst (yypvt[-2], 0, yypvt[-1], yypvt[-0]);
		} break;
case 50:
# line 825 "parser.y"
{
		  /* Pseudo divide operations */
		  div_inst (yypvt[-3], yypvt[-2], yypvt[-1], yypvt[-0], 0);
		} break;
case 51:
# line 831 "parser.y"
{
		  if (zero_imm ((imm_expr *)yypvt[-0]))
		    yyerror ("Divide by zero");
		  else
		    {
		      /* Use $at */
		      i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0]);
		      div_inst (yypvt[-3], yypvt[-2], yypvt[-1], 1, 1);
		    }
		} break;
case 52:
# line 844 "parser.y"
{
		  mult_inst (yypvt[-3], yypvt[-2], yypvt[-1], yypvt[-0]);
		} break;
case 53:
# line 849 "parser.y"
{
		  if (zero_imm ((imm_expr *)yypvt[-0]))
		    r_type_inst (Y_ORI_OP, yypvt[-2], 0, 0);
		  else
		    {
		      /* Use $at */
		      i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0]);
		      mult_inst (yypvt[-3], yypvt[-2], yypvt[-1], 1);
		    }
		} break;
case 54:
# line 862 "parser.y"
{
		  r_type_inst (yypvt[-2], 0, yypvt[-1], yypvt[-0]);
		} break;
case 55:
# line 868 "parser.y"
{
		  r_type_inst (Y_SUBU_OP, 1, 0, yypvt[-0]);
		  r_type_inst (Y_SLLV_OP, 1, 1, yypvt[-1]);
		  r_type_inst (Y_SRLV_OP, yypvt[-2], yypvt[-0], yypvt[-1]);
		  r_type_inst (Y_OR_OP, yypvt[-2], yypvt[-2], 1);
		} break;
case 56:
# line 877 "parser.y"
{
		  r_type_inst (Y_SUBU_OP, 1, 0, yypvt[-0]);
		  r_type_inst (Y_SRLV_OP, 1, 1, yypvt[-1]);
		  r_type_inst (Y_SLLV_OP, yypvt[-2], yypvt[-0], yypvt[-1]);
		  r_type_inst (Y_OR_OP, yypvt[-2], yypvt[-2], 1);
		} break;
case 57:
# line 886 "parser.y"
{
		  long dist = eval_imm_expr ((imm_expr *)yypvt[-0]);

		  r_sh_type_inst (Y_SLL_OP, 1, yypvt[-1], -dist);
		  r_sh_type_inst (Y_SRL_OP, yypvt[-2], yypvt[-1], dist);
		  r_type_inst (Y_OR_OP, yypvt[-2], yypvt[-2], 1);
		} break;
case 58:
# line 896 "parser.y"
{
		  long dist = eval_imm_expr ((imm_expr *)yypvt[-0]);

		  r_sh_type_inst (Y_SRL_OP, 1, yypvt[-1], -dist);
		  r_sh_type_inst (Y_SLL_OP, yypvt[-2], yypvt[-1], dist);
		  r_type_inst (Y_OR_OP, yypvt[-2], yypvt[-2], 1);
		} break;
case 59:
# line 907 "parser.y"
{
		  set_le_inst (yypvt[-3], yypvt[-2], yypvt[-1], yypvt[-0]);
		} break;
case 60:
# line 912 "parser.y"
{
		  if (!zero_imm ((imm_expr *)yypvt[-0]))
		    /* Use $at */
		    i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0]);
		  set_le_inst (yypvt[-3], yypvt[-2], yypvt[-1], (zero_imm ((imm_expr *)yypvt[-0]) ? 0 : 1));
		} break;
case 61:
# line 921 "parser.y"
{
		  set_gt_inst (yypvt[-3], yypvt[-2], yypvt[-1], yypvt[-0]);
		} break;
case 62:
# line 926 "parser.y"
{
		  if (!zero_imm ((imm_expr *)yypvt[-0]))
		    /* Use $at */
		    i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0]);
		  set_gt_inst (yypvt[-3], yypvt[-2], yypvt[-1], (zero_imm ((imm_expr *)yypvt[-0]) ? 0 : 1));
		} break;
case 63:
# line 936 "parser.y"
{
		  set_ge_inst (yypvt[-3], yypvt[-2], yypvt[-1], yypvt[-0]);
		} break;
case 64:
# line 941 "parser.y"
{
		  if (!zero_imm ((imm_expr *)yypvt[-0]))
		    /* Use $at */
		    i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0]);
		  set_ge_inst (yypvt[-3], yypvt[-2], yypvt[-1], (zero_imm ((imm_expr *)yypvt[-0]) ? 0 : 1));
		} break;
case 65:
# line 950 "parser.y"
{
		  set_eq_inst (yypvt[-3], yypvt[-2], yypvt[-1], yypvt[-0]);
		} break;
case 66:
# line 955 "parser.y"
{
		  if (!zero_imm ((imm_expr *)yypvt[-0]))
		    /* Use $at */
		    i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-0]);
		  set_eq_inst (yypvt[-3], yypvt[-2], yypvt[-1], (zero_imm ((imm_expr *)yypvt[-0]) ? 0 : 1));
		} break;
case 67:
# line 964 "parser.y"
{
		  i_type_inst (yypvt[-1], 0, 0, (imm_expr *)yypvt[-0]);
		} break;
case 68:
# line 970 "parser.y"
{
		  i_type_inst (yypvt[-2], 0, yypvt[-1], (imm_expr *)yypvt[-0]);
		} break;
case 69:
# line 976 "parser.y"
{
		  i_type_inst (yypvt[-2] == Y_BEQZ_POP ? Y_BEQ_OP : Y_BNE_OP,
			       0, yypvt[-1], (imm_expr *)yypvt[-0]);
		} break;
case 70:
# line 983 "parser.y"
{
		  i_type_inst (yypvt[-3], yypvt[-1], yypvt[-2], (imm_expr *)yypvt[-0]);
		} break;
case 71:
# line 988 "parser.y"
{
		  if (bare_machine)
		    yyerror ("Immediate form not allowed in bare machine");
		  else
		    {
		      if (zero_imm ((imm_expr *)yypvt[-1]))
			i_type_inst (yypvt[-3], yypvt[-2], (zero_imm ((imm_expr *)yypvt[-1]) ? 0 : 1),
				     (imm_expr *)yypvt[-0]);
		      else
			{
			  /* Use $at */
			  i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-1]);
			  i_type_inst (yypvt[-3], yypvt[-2], (zero_imm ((imm_expr *)yypvt[-1]) ? 0 : 1),
				       (imm_expr *)yypvt[-0]);
			}
		    }
		} break;
case 72:
# line 1008 "parser.y"
{
		  r_type_inst (yypvt[-3] == Y_BGT_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, yypvt[-1], yypvt[-2]); /* Use $at */
		  i_type_inst (Y_BNE_OP, 0, 1, (imm_expr *)yypvt[-0]);
		} break;
case 73:
# line 1015 "parser.y"
{
		  if (yypvt[-3] == Y_BGT_POP)
		    {
		      /* Use $at */
		      i_type_inst (Y_SLTI_OP, 1, yypvt[-2],
				   incr_expr_offset ((imm_expr *)yypvt[-1], 1));
		      i_type_inst (Y_BEQ_OP, 0, 1, (imm_expr *)yypvt[-0]);
		    }
		  else
		    {
		      /* Use $at */
		      /* Can't add 1 to immediate since 0xffffffff+1 = 0 < 1 */
		      i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-1]);
		      i_type_inst (Y_BEQ_OP, yypvt[-2], 1, branch_offset (3));
		      r_type_inst (Y_SLTU_OP, 1, yypvt[-2], 1);
		      i_type_inst (Y_BEQ_OP, 0, 1, (imm_expr *)yypvt[-0]);
		    }
		} break;
case 74:
# line 1036 "parser.y"
{
		  r_type_inst (yypvt[-3] == Y_BGE_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, yypvt[-2], yypvt[-1]); /* Use $at */
		  i_type_inst (Y_BEQ_OP, 0, 1, (imm_expr *)yypvt[-0]);
		} break;
case 75:
# line 1043 "parser.y"
{
		  i_type_inst (yypvt[-3] == Y_BGE_POP ? Y_SLTI_OP : Y_SLTIU_OP,
			       1, yypvt[-2], (imm_expr *)yypvt[-1]); /* Use $at */
		  i_type_inst (Y_BEQ_OP, 0, 1, (imm_expr *)yypvt[-0]);
		} break;
case 76:
# line 1051 "parser.y"
{
		  r_type_inst (yypvt[-3] == Y_BLT_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, yypvt[-2], yypvt[-1]); /* Use $at */
		  i_type_inst (Y_BNE_OP, 0, 1, (imm_expr *)yypvt[-0]);
		} break;
case 77:
# line 1058 "parser.y"
{
		  i_type_inst (yypvt[-3] == Y_BLT_POP ? Y_SLTI_OP : Y_SLTIU_OP,
			       1, yypvt[-2], (imm_expr *)yypvt[-1]); /* Use $at */
		  i_type_inst (Y_BNE_OP, 0, 1, (imm_expr *)yypvt[-0]);
		} break;
case 78:
# line 1066 "parser.y"
{
		  r_type_inst (yypvt[-3] == Y_BLE_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, yypvt[-1], yypvt[-2]); /* Use $at */
		  i_type_inst (Y_BEQ_OP, 0, 1, (imm_expr *)yypvt[-0]);
		} break;
case 79:
# line 1073 "parser.y"
{
		  if (yypvt[-3] == Y_BLE_POP)
		    {
		      /* Use $at */
		      i_type_inst (Y_SLTI_OP, 1, yypvt[-2],
				   incr_expr_offset ((imm_expr *)yypvt[-1], 1));
		      i_type_inst (Y_BNE_OP, 0, 1, (imm_expr *)yypvt[-0]);
		    }
		  else
		    {
		      /* Use $at */
		      /* Can't add 1 to immediate since 0xffffffff+1 = 0 < 1 */
		      i_type_inst (Y_ORI_OP, 1, 0, (imm_expr *)yypvt[-1]);
		      i_type_inst (Y_BEQ_OP, yypvt[-2], 1,
				   copy_imm_expr ((imm_expr *)yypvt[-0]));
		      r_type_inst (Y_SLTU_OP, 1, yypvt[-2], 1);
		      i_type_inst (Y_BNE_OP, 0, 1, (imm_expr *)yypvt[-0]);
		    }
		} break;
case 80:
# line 1095 "parser.y"
{
		  if ((yypvt[-1] == Y_J_OP) || (yypvt[-1] == Y_JR_OP))
		    j_type_inst (Y_J_OP, (imm_expr *)yypvt[-0]);
		  else if ((yypvt[-1] == Y_JAL_OP) || (yypvt[-1] == Y_JALR_OP))
		    j_type_inst (Y_JAL_OP, (imm_expr *)yypvt[-0]);
		} break;
case 81:
# line 1104 "parser.y"
{
		  if ((yypvt[-1] == Y_J_OP) || (yypvt[-1] == Y_JR_OP))
		    r_type_inst (Y_JR_OP, 0, yypvt[-0], 0);
		  else if ((yypvt[-1] == Y_JAL_OP) || (yypvt[-1] == Y_JALR_OP))
		    r_type_inst (Y_JALR_OP, 31, yypvt[-0], 0);
		} break;
case 82:
# line 1113 "parser.y"
{
		  if ((yypvt[-2] == Y_J_OP) || (yypvt[-2] == Y_JR_OP))
		    r_type_inst (Y_JR_OP, 0, yypvt[-0], 0);
		  else if ((yypvt[-2] == Y_JAL_OP) || (yypvt[-2] == Y_JALR_OP))
		    r_type_inst (Y_JALR_OP, yypvt[-1], yypvt[-0], 0);
		} break;
case 83:
# line 1122 "parser.y"
{
		  i_type_inst ((yypvt[-1] == Y_BAL_POP ? Y_BGEZAL_OP : Y_BGEZ_OP),
			       0, 0, (imm_expr *)yypvt[-0]);
		} break;
case 84:
# line 1130 "parser.y"
{
		  r_type_inst (yypvt[-2], yypvt[-1], yypvt[-0], 0);
		} break;
case 85:
# line 1136 "parser.y"
{
		  r_type_inst (yypvt[-1], yypvt[-0], 0, 0);
		} break;
case 86:
# line 1142 "parser.y"
{
		  r_type_inst (yypvt[-1], 0, yypvt[-0], 0);
		} break;
case 87:
# line 1148 "parser.y"
{
		  if (yypvt[-2] == Y_MFC1_D_POP)
		    {
		      r_type_inst (Y_MFC1_OP, yypvt[-0], 0, yypvt[-1]);
		      r_type_inst (Y_MFC1_OP, yypvt[-0] + 1, 0, yypvt[-1] + 1);
		    }
		  else if (yypvt[-2] == Y_MTC1_D_POP)
		    {
		      r_type_inst (Y_MTC1_OP, yypvt[-0], 0, yypvt[-1]);
		      r_type_inst (Y_MTC1_OP, yypvt[-0] + 1, 0, yypvt[-1] + 1);
		    }
		  else
		    r_type_inst (yypvt[-2], yypvt[-0], 0, yypvt[-1]);
		} break;
case 88:
# line 1165 "parser.y"
{
		  r_type_inst (yypvt[-2], yypvt[-0], 0, yypvt[-1]);
		} break;
case 89:
# line 1171 "parser.y"
{
		  r_type_inst (yypvt[-2], yypvt[-1], yypvt[-0], 0);
		} break;
case 90:
# line 1177 "parser.y"
{
		  r_type_inst (yypvt[-3], yypvt[-2], yypvt[-1], yypvt[-0]);
		} break;
case 91:
# line 1183 "parser.y"
{
		  r_type_inst (yypvt[-2], yypvt[-1], yypvt[-0], 0);
		} break;
case 92:
# line 1189 "parser.y"
{
		  r_type_inst (yypvt[-2], yypvt[-1], yypvt[-0], 0);
		} break;
case 93:
# line 1195 "parser.y"
{
		  r_cond_type_inst (yypvt[-2], yypvt[-1], yypvt[-0]);
		} break;
case 269:
# line 1468 "parser.y"
{
		  align_data (yypvt[-0]);
		} break;
case 270:
# line 1472 "parser.y"
{null_term = 0;} break;
case 271:
# line 1473 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 272:
# line 1478 "parser.y"
{null_term = 1;} break;
case 273:
# line 1479 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 276:
# line 1491 "parser.y"
{store_op = store_byte;} break;
case 277:
# line 1493 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 278:
# line 1500 "parser.y"
{
		  align_data (2);
		  if (lookup_label ((char *)yypvt[-1])->addr == 0)
		    record_label ((char *)yypvt[-1], current_data_pc ());
		  increment_data_pc (yypvt[-0]);
		} break;
case 279:
# line 1509 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		} break;
case 280:
# line 1516 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		  set_data_pc (yypvt[-0]);
		} break;
case 281:
# line 1525 "parser.y"
{
		  user_kernel_data_segment (1);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		} break;
case 282:
# line 1532 "parser.y"
{
		  user_kernel_data_segment (1);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		  set_data_pc (yypvt[-0]);
		} break;
case 283:
# line 1541 "parser.y"
{store_op = store_double; set_data_alignment(3);} break;
case 284:
# line 1543 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 290:
# line 1561 "parser.y"
{
		  extern_directive ((char *)yypvt[-1], yypvt[-0]);
		} break;
case 291:
# line 1567 "parser.y"
{
		  fatal_error ("File contains an .err directive\n");
		} break;
case 293:
# line 1576 "parser.y"
{store_op = store_float; set_data_alignment (2);} break;
case 294:
# line 1578 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 297:
# line 1590 "parser.y"
{
		  make_label_global ((char *)yypvt[-0]);
		} break;
case 298:
# line 1596 "parser.y"
{store_op = store_half; set_data_alignment (1);} break;
case 299:
# line 1598 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment");
		} break;
case 300:
# line 1605 "parser.y"
{
		  record_label ((char *)yypvt[-0], (text_dir ? current_text_pc ()
					     : current_data_pc ()));
		} break;
case 301:
# line 1612 "parser.y"
{
		  lcomm_directive ((char *)yypvt[-1], yypvt[-0]);
		} break;
case 307:
# line 1630 "parser.y"
{
		  yyerror ("Warning: repeat directive ignored");
		} break;
case 308:
# line 1636 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		} break;
case 309:
# line 1643 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		  set_data_pc (yypvt[-0]);
		} break;
case 310:
# line 1652 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		} break;
case 311:
# line 1659 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		  set_data_pc (yypvt[-0]);
		} break;
case 312:
# line 1668 "parser.y"
{
		  if (streq ((char *)yypvt[-0], "noat"))
		    noat_flag = 1;
		  else if (streq ((char *)yypvt[-0], "at"))
		    noat_flag = 0;
		} break;
case 313:
# line 1677 "parser.y"
{
		  if (data_dir)
		    increment_data_pc (yypvt[-0]);
		  else if (text_dir)
		    increment_text_pc (yypvt[-0]);
		} break;
case 314:
# line 1686 "parser.y"
{
		  yyerror ("Warning: struct directive ignored");
		} break;
case 315:
# line 1692 "parser.y"
{
		  user_kernel_text_segment (0);
		  data_dir = 0; text_dir = 1;
		  enable_data_alignment ();
		} break;
case 316:
# line 1699 "parser.y"
{
		  user_kernel_text_segment (0);
		  data_dir = 0; text_dir = 1;
		  enable_data_alignment ();
		  set_text_pc (yypvt[-0]);
		} break;
case 317:
# line 1708 "parser.y"
{
		  user_kernel_text_segment (1);
		  data_dir = 0; text_dir = 1;
		  enable_data_alignment ();
		} break;
case 318:
# line 1715 "parser.y"
{
		  user_kernel_text_segment (1);
		  data_dir = 0; text_dir = 1;
		  enable_data_alignment ();
		  set_text_pc (yypvt[-0]);
		} break;
case 321:
# line 1729 "parser.y"
{store_op = store_word_data; set_data_alignment (2);} break;
case 323:
# line 1736 "parser.y"
{only_id = 1;} break;
case 324:
# line 1736 "parser.y"
{only_id = 0; yyval = yypvt[-0];} break;
case 325:
# line 1739 "parser.y"
{
		  yyval = (int) make_addr_expr (0, NULL, yypvt[-1]);
		} break;
case 326:
# line 1744 "parser.y"
{
		  yyval = (int) make_addr_expr (yypvt[-0], NULL, 0);
		} break;
case 327:
# line 1749 "parser.y"
{
		  yyval = (int) make_addr_expr (yypvt[-3], NULL, yypvt[-1]);
		} break;
case 328:
# line 1754 "parser.y"
{
		  yyval = (int) make_addr_expr (0, (char *)yypvt[-0], 0);
		} break;
case 329:
# line 1759 "parser.y"
{
		  yyval = (int) make_addr_expr (0, (char *)yypvt[-3], yypvt[-1]);
		} break;
case 330:
# line 1764 "parser.y"
{
		  yyval = (int) make_addr_expr (yypvt[-0], (char *)yypvt[-2], 0);
		} break;
case 331:
# line 1769 "parser.y"
{
		  yyval = (int) make_addr_expr (yypvt[-2], (char *)yypvt[-0], 0);
		} break;
case 332:
# line 1774 "parser.y"
{
		  yyval = (int) make_addr_expr (- yypvt[-0], (char *)yypvt[-2], 0);
		} break;
case 333:
# line 1779 "parser.y"
{
		  yyval = (int) make_addr_expr (yypvt[-3], (char *)yypvt[-5], yypvt[-1]);
		} break;
case 334:
# line 1784 "parser.y"
{
		  yyval = (int) make_addr_expr (- yypvt[-3], (char *)yypvt[-5], yypvt[-1]);
		} break;
case 335:
# line 1790 "parser.y"
{only_id = 1;} break;
case 336:
# line 1790 "parser.y"
{only_id = 0; yyval = yypvt[-0];} break;
case 337:
# line 1793 "parser.y"
{
		  yyval = (int) make_imm_expr (yypvt[-0], NULL, 0);
		} break;
case 338:
# line 1798 "parser.y"
{
		  yyval = (int) make_imm_expr (yypvt[-4] >> yypvt[-0], NULL, 0);
		} break;
case 339:
# line 1803 "parser.y"
{
		  yyval = (int) make_imm_expr (0, (char *)yypvt[-0], 0);
		} break;
case 340:
# line 1808 "parser.y"
{
		  yyval = (int) make_imm_expr (yypvt[-0], (char *)yypvt[-2], 0);
		} break;
case 341:
# line 1813 "parser.y"
{
		  yyval = (int) make_imm_expr (- yypvt[-0], (char *)yypvt[-2], 0);
		} break;
case 343:
# line 1822 "parser.y"
{yyval = yypvt[-2] + yypvt[-0];} break;
case 344:
# line 1825 "parser.y"
{
		  /* Y_INT '-' Y_INT */
		  if (yypvt[-0] >= 0)
		    yyerror ("Syntax error");
		  yyval = yypvt[-1] - yypvt[-0];
		} break;
case 351:
# line 1846 "parser.y"
{
		  if (yypvt[-0] < 0 || yypvt[-0] > 31)
		    yyerror ("Register number out of range");
		  if (yypvt[-0] == 1 && !bare_machine && !noat_flag)
		    yyerror ("Register 1 is reserved for assembler");
		  yyval = yypvt[-0];
		} break;
case 355:
# line 1861 "parser.y"
{
		  if (yypvt[-0] < 0 || yypvt[-0] > 31)
		    yyerror ("FP register number out of range");
		  yyval = yypvt[-0];
		} break;
case 358:
# line 1876 "parser.y"
{
		  yyval = (int) make_imm_expr (- current_text_pc (), (char *)yypvt[-0],
					    1);
		} break;
case 361:
# line 1888 "parser.y"
{
		  store_string ((char *)yypvt[-0], y_str_length, null_term);
		} break;
case 362:
# line 1892 "parser.y"
{
		  int i;

		  for (i = 0; i < yypvt[-0]; i ++)
		    store_string ((char *)yypvt[-2], y_str_length, null_term);
		} break;
case 363:
# line 1901 "parser.y"
{only_id = 1;} break;
case 364:
# line 1901 "parser.y"
{only_id = 0; yyval = yypvt[-0];} break;
case 366:
# line 1906 "parser.y"
{
		  label *l = lookup_label ((char *)yypvt[-0]);

		  if (l->addr == 0)
		    {
		      record_data_uses_symbol (current_data_pc (), l);
		      yyval = 0;
		    }
		  else
		    yyval = l->addr;
		} break;
case 367:
# line 1920 "parser.y"
{
		  store_op (yypvt[-0]);
		} break;
case 368:
# line 1924 "parser.y"
{
		  store_op (yypvt[-0]);
		} break;
case 369:
# line 1928 "parser.y"
{
		  int i;

		  for (i = 0; i < yypvt[-0]; i ++)
		    store_op (yypvt[-2]);
		} break;
case 370:
# line 1938 "parser.y"
{
		  store_op (yypvt[-0]);
		} break;
case 371:
# line 1942 "parser.y"
{
		  store_op (yypvt[-0]);
		} break;
case 372:
# line 1948 "parser.y"
{only_id = 1;} break;
case 373:
# line 1948 "parser.y"
{only_id = 0; yyval = yypvt[-0];} break;
case 375:
# line 1951 "parser.y"
{yyval = 0;} break;
case 376:
# line 1955 "parser.y"
{only_id = 1;} break;
case 377:
# line 1955 "parser.y"
{only_id = 0; yyval = yypvt[-0];} break;
	}
	goto yystack;		/* reset registers in driver code */
}
